/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.ode.bpe.client.exceptions.BPEUserException;
import org.apache.ode.bpe.client.util.BPEInvoker;
import org.apache.ode.bpe.client.util.IBPEInvoker;
import org.apache.ode.bpe.client.util.IInvokerBuilder;

public class InvokerBuilder
implements IInvokerBuilder {
    private String packageName;

    public InvokerBuilder() {
        this.packageName = "BPE";
    }

    public InvokerBuilder(String packageName) {
        this.packageName = packageName;
    }

    public IBPEInvoker[] buildInvokers(String[] msgFiles) throws FileNotFoundException, IOException, BPEUserException {
        IBPEInvoker[] invokers = new IBPEInvoker[msgFiles.length];
        for (int j = 0; j < msgFiles.length; ++j) {
            Properties msg = new Properties();
            msg.load(new FileInputStream(new File(msgFiles[j])));
            invokers[j] = this.buildInvoker(msg);
        }
        return invokers;
    }

    private IBPEInvoker createExternalInvoker(Properties invocation) throws BPEUserException {
        String invokerImplClass = invocation.getProperty("invoker.impl");
        if (invokerImplClass != null) {
            try {
                Class<?> invokerClass = Class.forName(invokerImplClass);
                IBPEInvoker invokerInstance = (IBPEInvoker)invokerClass.newInstance();
                invokerInstance.setInvocationSpec(invocation);
                return invokerInstance;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public IBPEInvoker buildInvoker(Properties invocation) throws BPEUserException {
        String partName;
        invocation.setProperty("packageName", this.packageName);
        IBPEInvoker bpi = this.createExternalInvoker(invocation);
        if (bpi == null) {
            bpi = new BPEInvoker(invocation);
        }
        Properties partDescriptor = invocation;
        int i = 1;
        while ((partName = invocation.getProperty("part" + String.valueOf(i++))) != null) {
            String[] partSplit = partName.split("\\.");
            if (partSplit.length < 2) {
                System.out.println("part name requires a type prefix");
                break;
            }
            String formatName = partSplit[0];
            String simplePartName = partSplit[1];
            Object partValue = ((Hashtable)invocation).get(partName);
            partDescriptor.setProperty("formatName", formatName);
            bpi.addPart(simplePartName, partValue, partDescriptor);
        }
        return bpi;
    }
}

