/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.ejb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ode.bpe.uo.util.ApplicationLocalStore;

public class ObjectCache {
    private static final String MAP_KEY = "OBJECT_CACHE_MAP_KEY";
    private static long updateCountBase = ((long)(Math.random() * 100000.0) + System.currentTimeMillis()) * 1000L;
    private static long maxCacheSize = Long.parseLong(System.getProperty("org.apache.ode.bpe.context.ejb.ObjectCache.maxCacheSize", "1000"));
    private Map cacheMap = ObjectCache.lookupMap();

    public Object get(String id) {
        Object retVal = this.getMap().get(id);
        return retVal;
    }

    public void remove(String id) {
        this.getMap().remove(id);
    }

    public void put(String id, Object object) {
        this.getMap().put(id, object);
        this.shrinkCache();
    }

    private void shrinkCache() {
        Map map = this.getMap();
        if ((long)map.size() > maxCacheSize) {
            Object[] keyArray = map.keySet().toArray();
            map.keySet().toArray();
            int randomindex = (int)Math.round(Math.floor(Math.random() * (double)keyArray.length));
            String key = (String)keyArray[randomindex];
            this.remove(key);
        }
    }

    public static long GetUpdateCount(long updateCount) {
        return updateCountBase + (updateCount & 0x1FFL);
    }

    private Map getMap() {
        Map returnValue;
        if (this.cacheMap == null) {
            returnValue = ObjectCache.lookupMap();
            if (returnValue == null) {
                returnValue = ObjectCache.CreateMap();
            }
            this.cacheMap = returnValue;
        } else {
            returnValue = this.cacheMap;
        }
        return returnValue;
    }

    private static Map lookupMap() {
        Map returnValue = (Map)ApplicationLocalStore.get(MAP_KEY);
        return returnValue;
    }

    private static synchronized Map CreateMap() {
        Map returnValue = ObjectCache.lookupMap();
        if (returnValue == null) {
            returnValue = Collections.synchronizedMap(new HashMap());
            ApplicationLocalStore.set(MAP_KEY, returnValue);
        }
        return returnValue;
    }
}

