/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.persistent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.DataObject;
import org.apache.ode.bpe.context.base.SuperNode;
import org.apache.ode.bpe.context.persistent.PersistentContainer;
import org.apache.ode.bpe.context.persistent.PersistentContextService;
import org.apache.ode.bpe.context.persistent.PersistentPart;

public class PersistentNode
extends SuperNode {
    static final long serialVersionUID = 26152360502563739L;
    transient PersistentNode m_root = null;
    private transient PersistentContextService m_service = null;

    PersistentNode() {
    }

    PersistentNode(String name, PersistentContainer parent) throws ContextServiceException {
        super(name, parent);
    }

    public void setContainer(PersistentContainer iContainer) throws ContextServiceException {
        super.setContainer(iContainer);
        this.setDirty(this);
    }

    public void setName(String iName) throws ContextServiceException {
        super.setName(iName);
        this.setDirty(this);
    }

    protected void setNameFromDeserialization(String iName) throws ContextServiceException {
        super.setName(iName);
    }

    void init(PersistentContainer parent) throws ContextServiceException {
        super.setContainer(parent);
    }

    protected void setDirty(SuperNode child) throws ContextServiceException {
        PersistentContainer container = (PersistentContainer)this.getContainer();
        if (container != null) {
            container.setDirty(this);
        }
    }

    protected void lockTree(SuperNode child) throws ContextServiceException {
        PersistentContainer container = (PersistentContainer)this.getContainer();
        if (container != null) {
            container.lockTree(this);
        }
    }

    PersistentContainer getPersistentContainer() {
        return (PersistentContainer)this.getContainer();
    }

    PersistentNode getRoot(PersistentNode child) {
        return this.getPersistentContainer().getRoot(this);
    }

    void setRoot(PersistentNode iRoot) {
        this.m_root = iRoot;
    }

    protected PersistentContextService getService() {
        if (this.m_service == null) {
            this.m_service = this.getPersistentContainer().getService();
        }
        return this.m_service;
    }

    protected void setService(PersistentContextService iService) {
        this.m_service = iService;
    }

    protected SuperNode createPartImpl() throws ContextServiceException {
        return new PersistentPart();
    }

    protected SuperNode createContainerImpl() throws ContextServiceException {
        PersistentContainer newContainer = new PersistentContainer();
        return newContainer;
    }

    protected DataObject createHandle(Object iObject) throws ContextServiceException {
        return (DataObject)this.getService().createLocalDataObject(iObject);
    }

    protected void readNodeElements(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String name = (String)s.readObject();
        try {
            this.setNameFromDeserialization(name);
        }
        catch (ContextServiceException e) {
            throw new IOException(e.toString());
        }
    }

    protected void writeNodeElements(ObjectOutputStream s) throws IOException {
        String name = this.getName();
        s.writeObject(name);
    }
}

