/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.serialimpl;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.ode.bpe.action.external.IExternalAction;
import org.apache.ode.bpe.definition.IPMDCorrelation;
import org.apache.ode.bpe.definition.IPMDCorrelationSetDef;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.serialimpl.PMDCorrelationSetDef_SerialImpl;
import org.apache.ode.bpe.definition.serialimpl.PMDCorrelation_SerialImpl;
import org.apache.ode.bpe.definition.serialimpl.PMDOperation_SerialImpl;
import org.apache.ode.bpe.definition.serialimpl.PMDProcess_SerialImpl;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.definition.service.unmanaged.DefinitionStateCache;
import org.apache.ode.bpe.definition.service.unmanaged.DefinitionStateEnum;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.uuid.UUIDService;

public class PMDRoot_SerialImpl
implements IPMDRoot,
Serializable {
    static final long serialVersionUID = -6876388314218052261L;
    private ProcessDefinitionKey key;
    private String label;
    private String version;
    private boolean state_type;
    private boolean protectedInstantiation;
    private String description;
    protected PMDProcess_SerialImpl process;
    protected transient UUIDService us;
    private ArrayList instaceCreatingOperations;
    private ArrayList metaNonInstanceCreatingOperations;
    private ArrayList operations;
    private HashMap operationHash;
    private ArrayList correlationSetDefs;
    private HashMap actionHash;
    private DefinitionStateEnum state = DefinitionStateEnum.ACTIVE;
    private transient Hashtable definitions;
    private transient Hashtable newDefinitions;
    private HashMap supportingDocs = new HashMap();
    private HashMap processIndex;

    public PMDRoot_SerialImpl(String label, String version, boolean stateless, UUIDService us, Hashtable definitions, Hashtable newDefinitions) throws DefinitionServiceException {
        this.key = new ProcessDefinitionKey(us);
        this.label = label;
        this.version = version;
        this.state_type = stateless;
        this.us = us;
        this.definitions = definitions;
        this.newDefinitions = newDefinitions;
        this.operations = new ArrayList();
        this.processIndex = new HashMap();
        this.operationHash = new HashMap();
        this.correlationSetDefs = new ArrayList();
        this.instaceCreatingOperations = new ArrayList();
        this.metaNonInstanceCreatingOperations = new ArrayList();
        this.actionHash = new HashMap();
    }

    public PMDRoot_SerialImpl() {
        this.operations = new ArrayList();
        this.processIndex = new HashMap();
        this.operationHash = new HashMap();
        this.correlationSetDefs = new ArrayList();
        this.instaceCreatingOperations = new ArrayList();
        this.metaNonInstanceCreatingOperations = new ArrayList();
        this.actionHash = new HashMap();
    }

    public IPMDProcess getProcess() {
        return this.process;
    }

    public void setProcess(IPMDProcess process) {
        this.process = (PMDProcess_SerialImpl)process;
    }

    public IPMDProcess createProcess(String label) throws DefinitionServiceException {
        this.process = new PMDProcess_SerialImpl(label, this, this.us);
        this.definitions.put(this.process.getKey(), this);
        this.newDefinitions.put(this.process.getKey(), this);
        return this.process;
    }

    public ProcessDefinitionKey getKey() {
        return this.key;
    }

    public void setKey(ProcessDefinitionKey key) {
        this.key = key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getIsStateless() {
        return this.state_type;
    }

    public void setIsStateless(boolean state) {
        this.state_type = state;
    }

    public HashMap getProcessIndex() {
        return this.processIndex;
    }

    public void setProcessIndex(HashMap index) {
        this.processIndex = index;
    }

    public void addSupportingDocument(String key, String supportDoc) {
        this.supportingDocs.put(key, supportDoc);
    }

    public String getSupportingDocument(String key) {
        return (String)this.supportingDocs.get(key);
    }

    public HashMap getSupportingDocuments() {
        return this.supportingDocs;
    }

    public void setSupportingDocuments(HashMap docs) {
        this.supportingDocs = docs;
    }

    public void addInstanceCreatingOperation(IPMDOperation op) {
        this.instaceCreatingOperations.add(op);
    }

    public IPMDCorrelationSetDef createCorrelationSet(String name, ArrayList partQueries) {
        PMDCorrelationSetDef_SerialImpl def = new PMDCorrelationSetDef_SerialImpl(name, partQueries);
        this.correlationSetDefs.add(def);
        return def;
    }

    public IPMDCorrelation createCorrelation(String name) {
        PMDCorrelation_SerialImpl cor = new PMDCorrelation_SerialImpl(name);
        return cor;
    }

    public IPMDOperation createOperation(String operationId, IStaticKey key, IPMDCorrelation corrl, boolean instanceCreating, String defId) {
        PMDOperation_SerialImpl op = new PMDOperation_SerialImpl(key, corrl, instanceCreating, this.getProcess().getKey().getValue(), defId, operationId);
        this.operations.add(op);
        this.operationHash.put(operationId, op);
        return op;
    }

    public Collection getInstanceCreatingOperations() {
        return this.instaceCreatingOperations;
    }

    public ArrayList getCorrelationSetDefs() {
        return this.correlationSetDefs;
    }

    public ArrayList getOperations() {
        return this.operations;
    }

    public void setCorrelationSetDefs(ArrayList list) {
        this.correlationSetDefs = list;
    }

    public void setInstaceCreatingOperations(Collection list) {
        this.instaceCreatingOperations = (ArrayList)list;
    }

    public void setOperations(ArrayList list) {
        this.operations = list;
        if (list != null) {
            Iterator it = ((AbstractList)list).iterator();
            while (it.hasNext()) {
                IPMDOperation op = (IPMDOperation)it.next();
                this.operationHash.put(op.getOperationId(), op);
            }
        }
    }

    public IPMDOperation getOperation(String operationId) {
        if (this.operationHash.size() != this.operations.size()) {
            this.setOperations(this.operations);
        }
        return (IPMDOperation)this.operationHash.get(operationId);
    }

    public IExternalAction getExternalAction(Object key) {
        return (IExternalAction)this.actionHash.get(key);
    }

    public void putExternalAction(Object key, IExternalAction value) {
        this.actionHash.put(key, value);
    }

    public void clearExternalAction() {
        Iterator itr = this.actionHash.values().iterator();
        while (itr.hasNext()) {
            IExternalAction iea = (IExternalAction)itr.next();
            iea.release();
        }
        this.actionHash.clear();
    }

    private IPMDOperation createMetaNonInstOp(String operationId, IStaticKey key, IPMDCorrelation corrl, boolean instanceCreating, String defId) {
        IPMDOperation op = this.createOperation(operationId, key, corrl, instanceCreating, defId);
        this.metaNonInstanceCreatingOperations.add(op);
        return op;
    }

    public IPMDOperation createOnMessageOperation(String operationId, IStaticKey key, IPMDCorrelation corrl, boolean instanceCreating, String defId) {
        return this.createMetaNonInstOp(operationId, key, corrl, instanceCreating, defId);
    }

    public IPMDOperation createRecieveOperation(String operationId, IStaticKey key, IPMDCorrelation corrl, boolean instanceCreating, String defId) {
        return this.createMetaNonInstOp(operationId, key, corrl, instanceCreating, defId);
    }

    public Collection getMetaNonInstanceCreatingOperations() {
        return this.metaNonInstanceCreatingOperations;
    }

    public void setProtectedInstantiation(boolean flag) {
        this.protectedInstantiation = flag;
    }

    public boolean getProtectedInstantiation() {
        return this.protectedInstantiation;
    }

    public int getState() {
        DefinitionStateEnum returnState = DefinitionStateCache.getState(this.key);
        if (returnState == null) {
            returnState = this.state;
            DefinitionStateCache.setState(this.key, returnState);
        } else {
            this.state = returnState;
        }
        return returnState.intValue();
    }

    public void setState(int state) {
        this.state = DefinitionStateEnum.getState(state);
        DefinitionStateCache.setState(this.key, this.state);
    }

    public boolean isActive() {
        return this.getState() == DefinitionStateEnum.ACTIVE.intValue();
    }
}

