/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELLinkedActivity;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELProcessType;
import org.apache.ode.bpe.deployment.bpel.BPELPropertyDefinition;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.deployment.bpel.ExtensibilityArtifacts;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertyAlias;

class BPELProcess
extends BPELStructuredActivity {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELProcess == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELProcess = BPELProcess.class$("org.apache.ode.bpe.deployment.bpel.BPELProcess")) : class$org$apache$ode$bpe$deployment$bpel$BPELProcess).getName());
    private IPMDRoot m_processRoot;
    private int m_scopeCount = 0;
    private HashMap m_bpelProps;
    private boolean m_isStateless = true;
    private HashSet instCreatingstaticKeys = new HashSet();
    private HashSet nonInstCreatingstaticKeys = new HashSet();
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELProcess;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$DefaultConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$EndProcessAction;

    BPELProcess(IPMDRoot newRoot, IPMDProcess process, BPELAttributes attrs, ExtensibilityArtifacts ea) throws DeploymentException {
        super(null, BPELSchema.PROCESS, attrs, logger);
        this.m_processRoot = newRoot;
        ea.setProcess(this);
        this.m_bpelProps = ea.buildProperties();
        this.m_process = process;
        this.m_endProcess = this.createProcess(this.m_attributes.getName() == null ? "end activity" : "end " + this.m_attributes.getName());
        this.createProcessSequence(this.getAttributes(), this.getEndProcess());
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        this.createProcessSequence(activity.getAttributes(), activity.getStartProcess());
        this.linkProcess(BPELProcessType.START, (BPELLinkedActivity)activity, BPELProcessType.START, true);
        ((BPELLinkedActivity)activity).linkProcess(BPELProcessType.END, this, BPELProcessType.END, false);
    }

    IPMDProcess createProcess(String label) throws DeploymentException {
        IPMDProcess ret = null;
        try {
            ret = this.m_process == null ? this.m_processRoot.createProcess(label) : this.m_process.createUnLinkedProcess(label);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEPROCESS", new Object[]{this.getProcess().getAttributes().getName(), label}, e);
        }
        return ret;
    }

    int getScopeCounter() {
        return this.m_scopeCount++;
    }

    BPELScopePath getScopePath(BPELScopePath path) {
        return path;
    }

    IPMDRoot getDefinitionRoot() {
        return this.m_processRoot;
    }

    BPELProcess getProcess() {
        return this;
    }

    BPELAttributes getPropertyAttributes(QName qn, QName varMsgType) throws DeploymentException {
        BPELPropertyDefinition bpelProp;
        BPELAttributes ret = new BPELAttributes();
        if (varMsgType == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_MSGTYPE_NOTFOUND", new Object[]{this.getProcess().getAttributes().getName(), qn.toString()}, null);
        }
        if ((bpelProp = (BPELPropertyDefinition)this.m_bpelProps.get(qn)) == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_PROPERTY_NOTFOUND", new Object[]{this.getProcess().getAttributes().getName(), qn.toString()}, null);
        }
        ((Hashtable)ret).put(BPELSchema.TYPE_ATTR.getValue(), bpelProp.getPropertyType());
        Iterator itr = bpelProp.getAlias();
        while (itr.hasNext()) {
            BPELPropertyAlias pa = (BPELPropertyAlias)itr.next();
            if (!varMsgType.equals(pa.getMessageType())) continue;
            if (pa.getPart() != null) {
                ret.setProperty(BPELSchema.PART_ATTR.getValue(), pa.getPart());
            }
            if (pa.getQuery() != null) {
                ret.setProperty(BPELSchema.QUERY_ATTR.getValue(), pa.getQuery());
            }
            if (pa.getNamspaceMap() != null) {
                ret.setProperty("NSMAP", pa.getNamspaceMap());
            }
            ret.setProperty(BPELSchema.NAME_ATTR.getValue(), qn.getLocalPart());
            break;
        }
        return ret;
    }

    BPELNode pop() throws DeploymentException {
        IPMDChangeCondition cc = null;
        try {
            cc = this.getEndProcess().createChangeCondition("End Process: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELProcess.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            cc.createAction("End Process: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$action$bpel$EndProcessAction == null ? (class$org$apache$ode$bpe$action$bpel$EndProcessAction = BPELProcess.class$("org.apache.ode.bpe.action.bpel.EndProcessAction")) : class$org$apache$ode$bpe$action$bpel$EndProcessAction).getName());
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e);
        }
        return null;
    }

    BPELVariable getVariable(String varName) throws DeploymentException {
        BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_VARNOTFOUND", new Object[]{this.getAttributes().getName(), varName}, null);
        return null;
    }

    void setIsStateFull() {
        this.m_isStateless = false;
    }

    boolean getStateFlag() {
        return this.m_isStateless;
    }

    void addInstanceCreatingStaticKey(IStaticKey staticKey) {
        this.instCreatingstaticKeys.add(((Object)staticKey).toString());
    }

    void addNonInstanceCreatingStaticKey(IStaticKey staticKey) {
        this.nonInstCreatingstaticKeys.add(((Object)staticKey).toString());
    }

    boolean getIsProtectedInstantiation() {
        Iterator it = this.instCreatingstaticKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (this.nonInstCreatingstaticKeys.add(key)) continue;
            logger.log(Level.WARNING, ResourceGetter.getString("BPEL_PROTECT_INST"));
            return true;
        }
        return false;
    }

    String getNamespace(String prefix) throws DeploymentException {
        String uri = super.getNamespace(prefix);
        if (uri == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "DEPLOY_UNKNOWN_NS", new Object[]{this.getAttributes().getName(), prefix}, null);
        }
        return uri;
    }

    String getTargetNamespace() throws DeploymentException {
        String tns = this.getAttributes().getProperty("targetNamespace");
        if (tns == null) {
            tns = this.getAttributes().getProperty("xmlns");
        }
        if (tns == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_TNSNOTFOUND", null, null);
        }
        return this.getAttributes().getProperty("targetNamespace");
    }

    String getQueryLanguage() {
        return this.getAttributes().getQueryLanguage();
    }

    String getExpressionLanguage() {
        return this.getAttributes().getExpressionLanguage();
    }

    String getActivityDescription() {
        return "process is the root node of a business process";
    }

    public void addSupportingDocument(String key, String supportDoc) {
        this.m_processRoot.addSupportingDocument(key, supportDoc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

