/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.action.bpel.XPathJaxenExpression;
import org.apache.ode.bpe.action.bpel.XPathSwitchTuple;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELCase;
import org.apache.ode.bpe.deployment.bpel.BPELExpressionVariable;
import org.apache.ode.bpe.deployment.bpel.BPELFlow;
import org.apache.ode.bpe.deployment.bpel.BPELInvocationType;
import org.apache.ode.bpe.deployment.bpel.BPELLink;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELOtherwise;
import org.apache.ode.bpe.deployment.bpel.BPELProcessType;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;

class BPELSwitch
extends BPELStructuredActivity {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELStructuredActivity == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELStructuredActivity = BPELSwitch.class$("org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity")) : class$org$apache$ode$bpe$deployment$bpel$BPELStructuredActivity).getName());
    private static final String XPATH_SWITCH_CLASS = (class$org$apache$ode$bpe$action$bpel$XPathSwitchAction == null ? (class$org$apache$ode$bpe$action$bpel$XPathSwitchAction = BPELSwitch.class$("org.apache.ode.bpe.action.bpel.XPathSwitchAction")) : class$org$apache$ode$bpe$action$bpel$XPathSwitchAction).getName();
    private static final String DEFAULT_CONDITION_CLASS = (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELSwitch.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName();
    private static final String UNINITVAR_LABEL = "UNINITVAR";
    private static final String SWITCH_COND_LABEL = "Switch Condition: ";
    private static final String SWITCH_ACTION_LABEL = "Switch Action : ";
    private Vector cases = new Vector();
    private BPELOtherwise otherwise;
    private Vector links = new Vector();
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELStructuredActivity;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$XPathSwitchAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$DefaultConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$EndConditionalFlowAction;

    BPELSwitch(BPELNode previous, BPELAttributes attrs) throws DeploymentException {
        super(previous, BPELSchema.SWITCH, attrs, logger);
        this.createProcessSequence(this.getAttributes(), this.getEndProcess());
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        if (activity instanceof BPELOtherwise) {
            this.otherwise = (BPELOtherwise)activity;
        } else {
            this.cases.add(activity);
        }
    }

    BPELNode pop() throws DeploymentException {
        this.createCases();
        this.createEnd();
        return super.pop();
    }

    String getActivityDescription() {
        return "switch is implemented by: " + (class$org$apache$ode$bpe$action$bpel$XPathSwitchAction == null ? (class$org$apache$ode$bpe$action$bpel$XPathSwitchAction = BPELSwitch.class$("org.apache.ode.bpe.action.bpel.XPathSwitchAction")) : class$org$apache$ode$bpe$action$bpel$XPathSwitchAction).getName() + ". It is a container used to execute a single activity from a choice of activities.";
    }

    void createCases() throws DeploymentException {
        Vector<XPathSwitchTuple> v = new Vector<XPathSwitchTuple>();
        IPMDAction da = null;
        try {
            IPMDChangeCondition cc = this.getStartProcess().createChangeCondition(SWITCH_COND_LABEL + this.getAttributes().getName(), DEFAULT_CONDITION_CLASS);
            da = cc.createAction(SWITCH_ACTION_LABEL + this.getAttributes().getName(), XPATH_SWITCH_CLASS);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e);
        }
        Iterator itr = ((AbstractList)this.cases).iterator();
        while (itr.hasNext()) {
            BPELCase caseActivity = (BPELCase)itr.next();
            BPELExpressionVariable expVar = new BPELExpressionVariable(caseActivity.getAttributes().getCondition());
            v.add(new XPathSwitchTuple((XPathJaxenExpression)expVar.createLocator(da, this, caseActivity, null, BPELInvocationType.SELECT_VALUE, false), caseActivity.getActivity().getStartProcess().getKey()));
            caseActivity.getActivity().linkProcess(BPELProcessType.END, this, BPELProcessType.END, false);
        }
        Properties md = new Properties();
        ((Hashtable)md).put(UNINITVAR_LABEL, new UnInitVariableMetaData("http://schemas.xmlsoap.org/ws/2003/03/business-process/", "uninitializedVariable"));
        ((Hashtable)md).put("CASES", v);
        if (this.otherwise == null) {
            ((Hashtable)md).put("DEFAULT", this.getEndProcess().getKey());
        } else {
            ((Hashtable)md).put("DEFAULT", this.otherwise.getActivity().getStartProcess().getKey());
            this.otherwise.getActivity().linkProcess(BPELProcessType.END, this, BPELProcessType.END, false);
        }
        da.setMetadata(md);
    }

    void createEnd() throws DeploymentException {
        Vector<Object> linkLocators = new Vector<Object>();
        IPMDChangeCondition ccE = null;
        IPMDAction es = null;
        try {
            ccE = this.getEndProcess().createChangeCondition("End Switch: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELSwitch.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            es = ccE.createAction("End Switch: " + this.getAttributes().getName(), (class$org$apache$ode$bpe$action$bpel$EndConditionalFlowAction == null ? (class$org$apache$ode$bpe$action$bpel$EndConditionalFlowAction = BPELSwitch.class$("org.apache.ode.bpe.action.bpel.EndConditionalFlowAction")) : class$org$apache$ode$bpe$action$bpel$EndConditionalFlowAction).getName());
        }
        catch (DefinitionServiceException e1) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getAttributes().getName()}, e1);
        }
        Iterator linkItr = ((AbstractList)this.links).iterator();
        while (linkItr.hasNext()) {
            BPELLink link = (BPELLink)linkItr.next();
            BPELVariable var = link.getTransitionCondVar();
            linkLocators.add(var.createLocator(es, this, null, null, true));
        }
        Properties md = new Properties();
        ((Hashtable)md).put("links", linkLocators);
        es.setMetadata(md);
    }

    BPELLink notifyLink(BPELLink link, BPELFlow node) throws DeploymentException {
        if (link.getSource() != this && link.getTarget() != this) {
            this.links.add(link);
        }
        if (this.m_parserStack != null) {
            return this.m_parserStack.notifyLink(link, node);
        }
        return null;
    }

    BPELNode getProxy(BPELFlow linkOwner, BPELNode source) {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

