/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.event;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.event.EventException;
import org.apache.ode.bpe.event.IInternalEvent;
import org.apache.ode.bpe.util.BPException;

public class ProcessInstanceEvent
implements IInternalEvent,
Serializable {
    static final long serialVersionUID = 6822192926494036924L;
    public static String PROCESS_KEY_NAME = "ProcessKey";
    private String pKey;
    private String rootKey;

    public ProcessInstanceEvent(String rootKey, String pKey) {
        this.pKey = pKey;
        this.rootKey = rootKey;
    }

    public ProcessInstanceEvent() {
        this.pKey = null;
    }

    public void init(Properties attributes) throws EventException {
        Object obj = ((Hashtable)attributes).get(PROCESS_KEY_NAME);
        if (!(obj instanceof String)) {
            throw new EventException("INVALID_PROCESS_ID", new Object[]{this.pKey});
        }
        this.pKey = (String)obj;
    }

    public void apply(ProcessInstance processInstance, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        if (this.pKey != null && !this.pKey.equals(processInstance.getKey())) {
            throw new EventException("INVALID_PROCESS_ID", new Object[]{this.pKey});
        }
    }

    public Properties getAttributes() {
        Properties retVal = new Properties();
        ((Hashtable)retVal).put(PROCESS_KEY_NAME, this.pKey);
        return retVal;
    }

    public String getProcessInstanceKey() {
        return this.pKey;
    }

    public String getRootProcessInstanceKey() {
        return this.rootKey;
    }
}

