/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.event;

import java.util.Iterator;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.ode.bpe.event.EventException;
import org.apache.ode.bpe.event.Fault;
import org.apache.ode.bpe.event.SimpleResponseMessage;
import org.apache.ode.bpe.event.UnsupportedInteractionTypeException;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.XMLInteractionObject;
import org.apache.ode.bpe.util.BPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPResponseMessage
extends SimpleResponseMessage {
    static final long serialVersionUID = 1417189686562681151L;
    private SOAPEnvelope m_responseEnvelope;
    private boolean m_isDirty;

    public SOAPResponseMessage(SOAPEnvelope iResponseEnvelope) {
        this.m_responseEnvelope = iResponseEnvelope;
    }

    public SOAPEnvelope getResponseEnvelope() throws BPException {
        this.marshalToEnvelope();
        return this.m_responseEnvelope;
    }

    private void scrubEnvelope() throws BPException {
        try {
            this.scrubBody(this.m_responseEnvelope.getBody());
            this.scrubHeader(this.m_responseEnvelope.getHeader());
        }
        catch (Exception e) {
            throw new EventException("NATIVE_EXCEPTION", new Object[]{"SOAPException"}, e);
        }
    }

    private void scrubBody(SOAPBody iBody) throws BPException {
        iBody.detachNode();
    }

    private void scrubHeader(SOAPHeader iHeader) throws BPException {
        iHeader.detachNode();
    }

    public void setHeaderElement(String iName, IInteraction iHeaderInteraction) throws BPException {
        this.m_isDirty = true;
        if (!(iHeaderInteraction instanceof XMLInteractionObject)) {
            throw new UnsupportedInteractionTypeException();
        }
        super.setHeaderElement(iName, iHeaderInteraction);
    }

    public void setPart(String iPartName, IInteraction iInteraction) throws BPException {
        this.m_isDirty = true;
        if (!(iInteraction instanceof XMLInteractionObject)) {
            throw new UnsupportedInteractionTypeException();
        }
        super.setPart(iPartName, iInteraction);
    }

    public void marshalToEnvelope() throws BPException {
        try {
            if (this.m_isDirty) {
                Fault fault;
                this.scrubEnvelope();
                Iterator iterator = this.getPartMap().values().iterator();
                SOAPBody body = this.m_responseEnvelope.addBody();
                while (iterator.hasNext()) {
                    XMLInteractionObject interaction = (XMLInteractionObject)iterator.next();
                    Document document = interaction.getDocument();
                    SOAPBodyElement se = new SOAPBodyElement(document.getDocumentElement());
                    body.addChildElement((SOAPElement)se);
                }
                if (this.hasHeaders()) {
                    SOAPHeader header = this.m_responseEnvelope.addHeader();
                    iterator = this.getHeaderMap().values().iterator();
                    while (iterator.hasNext()) {
                        XMLInteractionObject headerInteraction = (XMLInteractionObject)iterator.next();
                        Document headerDocument = headerInteraction.getDocument();
                        Element headerElement = headerDocument.getDocumentElement();
                        SOAPHeaderElement she = new SOAPHeaderElement(headerElement);
                        header.addChildElement((SOAPElement)she);
                    }
                }
                if ((fault = this.getFault()) != null) {
                    SOAPFault soapFault = body.addFault();
                    soapFault.setFaultActor(fault.getFaultActor());
                    soapFault.setFaultCode(fault.getFaultCode());
                    soapFault.setFaultString(fault.getFaultString());
                }
            }
        }
        catch (Exception e) {
            throw new EventException("NATIVE_EXCEPTION", new Object[]{"Exception"}, e);
        }
    }
}

