/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.instance.persistent;

import java.io.Serializable;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.persistent.InstanceServicePersistentImpl;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.util.BPException;

public class PMIProcessPersistentImpl
implements IPMIProcess,
Serializable {
    static final long serialVersionUID = 4013280109638724771L;
    private String key;
    private String rootKey;
    private String defKey;
    private String contextContainerId;
    private String executionCtx = "process";
    private int state = StateEnum.UNSTARTED.getIntValue();
    private ScopePath scopePath = new ScopePath();
    private transient boolean markedForCleanUp;
    private transient InstanceServicePersistentImpl service;
    private transient IPMDProcess pDefinition;

    public PMIProcessPersistentImpl() {
    }

    public PMIProcessPersistentImpl(String rootKey, String defKey, InstanceServicePersistentImpl service) {
        this.key = service.getUUIDService().getUUID();
        this.defKey = defKey;
        if (rootKey == null) {
            this.contextContainerId = this.key;
            this.rootKey = this.key;
            ProcessDefinitionKey pdk = new ProcessDefinitionKey(defKey);
            try {
                this.pDefinition = service.getDefinitionService().getProcessDefintion(pdk, pdk);
            }
            catch (BPException e) {}
        } else {
            this.rootKey = rootKey;
        }
        this.service = service;
    }

    private PMIProcessPersistentImpl(String rootKey, IPMDProcess pDefKey, InstanceServicePersistentImpl service, ScopePath scopePath, String ctxid, String execCtx) {
        this(rootKey, pDefKey.getKey().getValue(), service);
        this.pDefinition = pDefKey;
        this.scopePath = scopePath;
        this.contextContainerId = ctxid;
        this.executionCtx = execCtx;
    }

    public IPMIProcess createSubProcess(IPMDProcess definition) throws BPException {
        PMIProcessPersistentImpl ret;
        try {
            ret = new PMIProcessPersistentImpl(this.getRootKey(), definition, this.service, (ScopePath)this.scopePath.clone(), this.contextContainerId, this.executionCtx);
        }
        catch (CloneNotSupportedException e) {
            throw new BPException("NATIVE_EXCEPTION", new Object[]{"CloneNotSupportedException"}, e);
        }
        this.service.addInstance(this.getRootKey(), ret);
        return ret;
    }

    public void setProcessService(InstanceServicePersistentImpl service) {
        this.service = service;
    }

    public void remove() throws BPException {
        if (!this.rootKey.equals(this.key)) {
            this.service.remove(this.rootKey, this.key);
        }
    }

    public boolean isMarkedForCleanUp() {
        return this.markedForCleanUp;
    }

    public void setMarkedForCleanUp(boolean b) {
        this.markedForCleanUp = b;
    }

    public IPMDProcess getDefinition() throws BPException {
        if (this.pDefinition == null) {
            PMIProcessPersistentImpl rootproc = (PMIProcessPersistentImpl)this.service.getInstance(this.rootKey, this.rootKey);
            ProcessDefinitionKey pdk = new ProcessDefinitionKey(this.defKey);
            ProcessDefinitionKey rpdk = new ProcessDefinitionKey(rootproc.defKey);
            this.pDefinition = this.service.getDefinitionService().getProcessDefintion(pdk, rpdk);
        }
        return this.pDefinition;
    }

    public boolean isStateless() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getRootKey() {
        return this.rootKey;
    }

    public void setRootKey(String string) {
        this.rootKey = string;
    }

    public String getDefKey() {
        return this.defKey;
    }

    public void setDefKey(String string) {
        this.defKey = string;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        this.state = i;
    }

    public boolean isPaused() {
        return this.getState() == StateEnum.PAUSED.getIntValue();
    }

    public ScopePath getScopePath() {
        return this.scopePath;
    }

    public void setScopePath(ScopePath scopePath) {
        this.scopePath = scopePath;
    }

    public String getContextContainerId() {
        return this.contextContainerId;
    }

    public void setContextContaionerId(String id) {
        this.contextContainerId = id;
    }

    public String getExecutionContext() {
        return this.executionCtx;
    }

    public void setExecutionContext(String executionCtx) {
        this.executionCtx = executionCtx;
    }
}

