/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.locking;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ode.bpe.locking.LockingService;
import org.apache.ode.bpe.locking.LockingServiceException;
import org.apache.ode.bpe.util.BPEProperties;

public class DBLockingService
implements LockingService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$locking$DBLockingService == null ? (class$org$apache$ode$bpe$locking$DBLockingService = DBLockingService.class$("org.apache.ode.bpe.locking.DBLockingService")) : class$org$apache$ode$bpe$locking$DBLockingService).getName());
    private DataSource m_dataSource = null;
    private static final String DB_LOCKING_SERVICE_THE_DB = "java:comp/env/jdbc/theDB";
    private static final String DB_LOCKING_SERVICE_UPDATE = "update BPE_MUTEX set touch = ? where id = ?";
    private static final String DB_LOCKING_SERVICE_SELECT = "select count(*) from BPE_MUTEX";
    private static final String DB_LOCKING_SERVICE_DELETE = "delete from BPE_MUTEX";
    private static final String DB_LOCKING_SERVICE_INSERT = "insert into BPE_MUTEX (id, touch) values (?, ?)";
    private static final String DB_LOCKING_SERVICE_BATCH_INSERT = "insert into BPE_MUTEX select 0-id, touch from BPE_MUTEX";
    private static final String DB_LOCKING_SERVICE_CREATE = "create table BPE_MUTEX(id integer, touch char(1))";
    private static final String DB_LOCKING_SERVICE_INDEX = "create unique index pk_BPE_MUTEX on BPE_MUTEX(id)";
    private static boolean initialized = false;
    static /* synthetic */ Class class$org$apache$ode$bpe$locking$DBLockingService;

    public void lock(String aKey) {
        int hashCode = aKey.hashCode() % 1000;
        this.update(hashCode);
    }

    public void init(BPEProperties props) {
        try {
            int hashBuckets = Integer.valueOf(props.getLockingServiceHashBuckets());
            InitialContext ictx = new InitialContext();
            Object obj = ictx.lookup(DB_LOCKING_SERVICE_THE_DB);
            this.m_dataSource = (DataSource)obj;
            if (!initialized) {
                this.initDB(hashBuckets);
                initialized = true;
            }
        }
        catch (NamingException ne) {
            logger.log(Level.SEVERE, "", ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertMetaData(Connection aConn, int aHashBucketsSize) {
        PreparedStatement stmt = null;
        Statement stmt2 = null;
        try {
            stmt = aConn.prepareStatement(DB_LOCKING_SERVICE_DELETE);
            stmt.executeUpdate();
            stmt.close();
            stmt = aConn.prepareStatement(DB_LOCKING_SERVICE_INSERT);
            for (int cntr = 1; cntr < aHashBucketsSize; ++cntr) {
                stmt.setInt(1, cntr);
                stmt.setString(2, "I");
                stmt.executeUpdate();
            }
            stmt2 = aConn.prepareStatement(DB_LOCKING_SERVICE_BATCH_INSERT);
            stmt2.executeUpdate();
            stmt.setInt(1, 0);
            stmt.setString(2, "I");
            stmt.executeUpdate();
        }
        catch (SQLException se) {
            logger.log(Level.SEVERE, "", se);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException se) {}
                stmt = null;
            }
            if (stmt2 != null) {
                try {
                    stmt2.close();
                }
                catch (SQLException se) {}
                stmt2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection aConn, int aHashBucketsSize) {
        PreparedStatement stmt = null;
        try {
            stmt = aConn.prepareStatement(DB_LOCKING_SERVICE_CREATE);
            stmt.executeUpdate();
            stmt.close();
            stmt = aConn.prepareStatement(DB_LOCKING_SERVICE_INDEX);
            stmt.executeUpdate();
        }
        catch (SQLException se) {
            logger.log(Level.SEVERE, "", se);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException se) {}
                stmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDB(int aHashBucketsSize) {
        Connection conn = null;
        Statement stmt = null;
        int rowCount = 0;
        try {
            conn = this.m_dataSource.getConnection();
            stmt = conn.prepareStatement(DB_LOCKING_SERVICE_SELECT);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
            rs.close();
            if (rowCount != 2 * (aHashBucketsSize - 1) + 1) {
                this.insertMetaData(conn, aHashBucketsSize);
            }
        }
        catch (SQLException se) {
            this.createTable(conn, aHashBucketsSize);
            this.insertMetaData(conn, aHashBucketsSize);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException se) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(int aKey) {
        Connection conn = null;
        Statement stmt = null;
        int rowCount = 0;
        try {
            conn = this.m_dataSource.getConnection();
            stmt = conn.prepareStatement(DB_LOCKING_SERVICE_UPDATE);
            stmt.setString(1, "U");
            stmt.setInt(2, aKey);
            rowCount = stmt.executeUpdate();
            if (rowCount != 1) {
                logger.log(Level.SEVERE, "", new LockingServiceException("DB_LOCKING_SERVICE", new Object[]{"update"}));
            }
        }
        catch (SQLException se) {
            logger.log(Level.SEVERE, "", se);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException se) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
                conn = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

