/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.scope.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.scope.service.impl.FCScopeInstanceImpl;
import org.apache.ode.bpe.util.BPException;

public class ScopeServiceImpl
implements IScopeService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$scope$service$impl$ScopeServiceImpl == null ? (class$org$apache$ode$bpe$scope$service$impl$ScopeServiceImpl = ScopeServiceImpl.class$("org.apache.ode.bpe.scope.service.impl.ScopeServiceImpl")) : class$org$apache$ode$bpe$scope$service$impl$ScopeServiceImpl).getName());
    private FCScopeInstanceImpl rootScope;
    static /* synthetic */ Class class$org$apache$ode$bpe$scope$service$impl$ScopeServiceImpl;

    public void init(IContextService cs, String ctxId) throws BPException {
        IContainer root = cs.getRoot();
        IContainer procroot = (IContainer)root.findChild(ctxId);
        IPart rootScopePart = (IPart)procroot.findChild("rootScope");
        if (rootScopePart == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Initializing context service for ctxid:" + ctxId);
            }
            rootScopePart = procroot.createPart("rootScope");
            this.rootScope = new FCScopeInstanceImpl();
            rootScopePart.setObject(this.rootScope);
        } else {
            this.rootScope = (FCScopeInstanceImpl)rootScopePart.getObjectForReadWrite();
        }
    }

    public IFCScopeInstance getScope(ScopePath scopePath) throws BPException {
        return this.rootScope.getScope(scopePath);
    }

    public void compensate(String scopeName, IPMIProcess proc, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        FCScopeInstanceImpl parentScope = null;
        Iterator it = this.rootScope.getScopes().values().iterator();
        while (it.hasNext()) {
            FCScopeInstanceImpl scope = (FCScopeInstanceImpl)it.next();
            String name = scope.getScopePath().getCurrentScope();
            if (!name.startsWith(scopeName)) continue;
            parentScope = scope.getParentScope();
            break;
        }
        if (parentScope == null) {
            throw new BPException("SS_BAD_COMP_SCOPE_NAME", new Object[]{scopeName});
        }
        List completedScopes = parentScope.getCompletedChildrenScopes();
        for (int i = completedScopes.size(); i > 0; --i) {
            IFCScopeInstance scope = (IFCScopeInstance)completedScopes.get(i - 1);
            String name = scope.getScopePath().getCurrentScope();
            if (!name.startsWith(scopeName)) continue;
            scope.compensate(proc, ec, pcb);
        }
    }

    public IFCScopeInstance getRootScope() throws BPException {
        return this.rootScope;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

