/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.timerservice;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.inmemory.jndi.IMContext;
import org.apache.ode.bpe.timerservice.IBPETimerService;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;

public class BPETimerServiceFactory {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$timerservice$BPETimerServiceFactory == null ? (class$org$apache$ode$bpe$timerservice$BPETimerServiceFactory = BPETimerServiceFactory.class$("org.apache.ode.bpe.timerservice.BPETimerServiceFactory")) : class$org$apache$ode$bpe$timerservice$BPETimerServiceFactory).getName());
    public static String BPETIMER_CLASS = "BPETIMER_CLASS_KEY";
    static /* synthetic */ Class class$org$apache$ode$bpe$timerservice$BPETimerServiceFactory;

    public static IBPETimerService getBPETimerService() throws BPException {
        BPEProperties props;
        try {
            String val = System.getProperty("java.naming.factory.initial");
            if (val != null && val.compareTo("org.apache.ode.bpe.inmemory.jndi.IMContextFactory") == 0) {
                props = new BPEProperties();
                IMContext.getProperties(props, "odeEngine.properties");
            } else {
                props = BPEProperties.getCachedProperties();
            }
        }
        catch (IOException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"IOException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return BPETimerServiceFactory.getBPETimerService(props);
    }

    private static IBPETimerService getBPETimerService(BPEProperties props) throws BPException {
        IBPETimerService ts;
        String className = props.getProperty(BPETIMER_CLASS);
        if (className == null) {
            return null;
        }
        try {
            Class<?> instClass = Class.forName(className);
            ts = (IBPETimerService)instClass.newInstance();
            ts.init(props);
        }
        catch (ClassNotFoundException e) {
            BPException bpx = new BPException("CLASS_NOT_FOUND", new Object[]{props.getProperty(BPETIMER_CLASS)});
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (InstantiationException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"InstantiationException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (IllegalAccessException e) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"IllegalAccessException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return ts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

