/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.SimpleRequestMessageEvent;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.util.BPException;

public class BPEPutMsg {
    public static void main(String[] args) {
        try {
            String partName;
            InitialContext context = new InitialContext();
            QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup("XAConnectionFactory");
            QueueConnection qConnection = qcf.createQueueConnection();
            QueueSession qSession = qConnection.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup("queue/BPED_IN");
            QueueSender qSender = qSession.createSender(queue);
            InteractionFactory interactionfactory = InteractionFactory.newInstance();
            Properties msg = new Properties();
            msg.load(new FileInputStream(args[0]));
            BPELStaticKey bsk = new BPELStaticKey();
            bsk.setTargetNamespace(msg.getProperty("target.name.space"));
            bsk.setPortType(msg.getProperty("port.type"));
            bsk.setOperation(msg.getProperty("operation"));
            SimpleRequestMessageEvent msgEvent = new SimpleRequestMessageEvent();
            msgEvent.setStaticKey(bsk);
            int i = 1;
            while ((partName = msg.getProperty("part" + String.valueOf(i++))) != null) {
                String[] partSplit = partName.split("\\.");
                if (partSplit.length < 2) {
                    System.out.println("part name requires a type prefix");
                    break;
                }
                IInteraction ior = null;
                if (partSplit[0].equals("xml")) {
                    ior = interactionfactory.createXMLInteraction(msg.getProperty(partName).getBytes());
                } else if (partSplit[0].equals("str")) {
                    ior = interactionfactory.createObjectInteraction(msg.getProperty(partName));
                }
                msgEvent.setPart(partSplit[1], ior);
            }
            ObjectMessage objmsg = qSession.createObjectMessage();
            objmsg.setObject((Serializable)msgEvent);
            qSender.send((Message)objmsg);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InteractionException e) {
            e.printStackTrace();
        }
        catch (BPException e) {
            e.printStackTrace();
        }
    }
}

