/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BPEPutTxtMsg {
    public static void main(String[] args) {
        try {
            String qcfName = "XAConnectionFactory";
            String qName = "queue/BPED_IN";
            String optParser = "JUNK";
            String optMsgType = "testMessage";
            int numMsgs = 1;
            boolean sendMarker = false;
            if (args.length > 2) {
                numMsgs = Integer.parseInt(args[1]);
            }
            if (args.length >= 4) {
                qcfName = args[2];
                qName = args[3];
            }
            if (args.length >= 5 && args[4].equals("-marker")) {
                sendMarker = true;
            }
            if (args.length == 7) {
                optParser = args[5];
                optMsgType = args[6];
            }
            InitialContext context = new InitialContext();
            QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(qcfName);
            QueueConnection qConnection = qcf.createQueueConnection();
            QueueSession qSession = qConnection.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(qName);
            QueueSender qSender = qSession.createSender(queue);
            Properties msg = new Properties();
            msg.load(new FileInputStream(args[0]));
            System.out.println("Target namespace:" + msg.getProperty("target.name.space"));
            System.out.println("PortType:" + msg.getProperty("port.type"));
            System.out.println("Operation:" + msg.getProperty("operation"));
            String partName = msg.getProperty("part1");
            String msgtxt = msg.getProperty(partName);
            TextMessage marker = null;
            if (sendMarker) {
                marker = qSession.createTextMessage();
                marker.setText("marker");
                qSender.send((Message)marker);
            }
            TextMessage txtmsg = qSession.createTextMessage();
            txtmsg.setText(msgtxt);
            txtmsg.setStringProperty("OPT_PARSER", optParser);
            txtmsg.setStringProperty("OPT_MSG_TYPE", optMsgType);
            for (int i = 0; i < numMsgs; ++i) {
                qSender.send((Message)txtmsg);
            }
            if (sendMarker) {
                qSender.send((Message)marker);
            }
            qSender.close();
            qSession.close();
            qConnection.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

