/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.servicemix.jbi.util.FileUtil;

public class FileSystemJarInputStream
extends InputStream
implements Runnable {
    private File root;
    private PipedInputStream input;
    private PipedOutputStream output;
    private Thread runner;
    private IOException exception;

    public FileSystemJarInputStream(File root) throws IOException {
        this.root = root;
        this.input = new PipedInputStream();
        this.output = new PipedOutputStream(this.input);
    }

    public int read() throws IOException {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.setDaemon(true);
            this.runner.start();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.input.read();
    }

    public void run() {
        try {
            JarOutputStream jos = new JarOutputStream(this.output);
            FileUtil.zipDir((String)this.root.getAbsolutePath(), (ZipOutputStream)jos, (String)"");
            jos.close();
        }
        catch (IOException e) {
            this.exception = e;
            try {
                this.output.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }
}

