/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;

public class DirectVmProducer
extends DefaultAsyncProducer {
    private DirectVmEndpoint endpoint;

    public DirectVmProducer(DirectVmEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        DirectVmConsumer consumer = this.endpoint.getComponent().getConsumer(this.endpoint);
        if (consumer == null) {
            throw new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
        }
        consumer.getProcessor().process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        DirectVmConsumer consumer = this.endpoint.getComponent().getConsumer(this.endpoint);
        if (consumer == null) {
            exchange.setException(new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange));
            callback.done(true);
            return true;
        }
        return this.endpoint.getConsumer().getAsyncProcessor().process(exchange, callback);
    }
}

