/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToEndpoint
implements Endpoint {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToEndpoint.class);
    private final Endpoint delegate;
    private Producer producer;
    private Processor detour;
    private boolean skip;

    public InterceptSendToEndpoint(Endpoint destination, boolean skip) {
        this.delegate = destination;
        this.skip = skip;
    }

    public void setDetour(Processor detour) {
        this.detour = detour;
    }

    public Endpoint getDelegate() {
        return this.delegate;
    }

    @Override
    public String getEndpointUri() {
        return this.delegate.getEndpointUri();
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.delegate.getEndpointConfiguration();
    }

    @Override
    public String getEndpointKey() {
        return this.delegate.getEndpointKey();
    }

    @Override
    public Exchange createExchange() {
        return this.delegate.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.delegate.createExchange(pattern);
    }

    @Override
    public Exchange createExchange(Exchange exchange) {
        return this.delegate.createExchange(exchange);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.delegate.getCamelContext();
    }

    @Override
    public Producer createProducer() throws Exception {
        this.producer = this.delegate.createProducer();
        return new DefaultAsyncProducer(this.delegate){

            @Override
            public Endpoint getEndpoint() {
                return InterceptSendToEndpoint.this.producer.getEndpoint();
            }

            @Override
            public Exchange createExchange() {
                return InterceptSendToEndpoint.this.producer.createExchange();
            }

            @Override
            public Exchange createExchange(ExchangePattern pattern) {
                return InterceptSendToEndpoint.this.producer.createExchange(pattern);
            }

            @Override
            public Exchange createExchange(Exchange exchange) {
                return InterceptSendToEndpoint.this.producer.createExchange(exchange);
            }

            @Override
            public boolean process(Exchange exchange, AsyncCallback callback) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending to endpoint: {} is intercepted and detoured to: {} for exchange: {}", new Object[]{this.getEndpoint(), InterceptSendToEndpoint.this.detour, exchange});
                }
                exchange.getIn().setHeader("CamelInterceptedEndpoint", InterceptSendToEndpoint.this.delegate.getEndpointUri());
                try {
                    InterceptSendToEndpoint.this.detour.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                if (!PipelineHelper.continueProcessing(exchange, "skip sending to original intended destination: " + this.getEndpoint(), LOG)) {
                    callback.done(true);
                    return true;
                }
                boolean shouldSkip = InterceptSendToEndpoint.this.skip;
                Boolean whenMatches = (Boolean)exchange.removeProperty("CamelInterceptSendToEndpointWhenMatched");
                if (whenMatches != null) {
                    boolean bl = shouldSkip = InterceptSendToEndpoint.this.skip && whenMatches != false;
                }
                if (!shouldSkip) {
                    if (exchange.hasOut()) {
                        exchange.setIn(exchange.getOut());
                        exchange.setOut(null);
                    }
                    if (InterceptSendToEndpoint.this.producer instanceof AsyncProcessor) {
                        AsyncProcessor async = (AsyncProcessor)((Object)InterceptSendToEndpoint.this.producer);
                        return async.process(exchange, callback);
                    }
                    try {
                        InterceptSendToEndpoint.this.producer.process(exchange);
                    }
                    catch (Exception e) {
                        exchange.setException(e);
                    }
                    callback.done(true);
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stop() means skip sending exchange to original intended destination: {} for exchange: {}", (Object)this.getEndpoint(), (Object)exchange);
                }
                callback.done(true);
                return true;
            }

            @Override
            public boolean isSingleton() {
                return InterceptSendToEndpoint.this.producer.isSingleton();
            }

            @Override
            public void start() throws Exception {
                ServiceHelper.startService(InterceptSendToEndpoint.this.detour);
                ServiceHelper.startService(InterceptSendToEndpoint.this.producer);
            }

            @Override
            public void stop() throws Exception {
                ServiceHelper.stopService(InterceptSendToEndpoint.this.producer);
            }
        };
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return this.delegate.createConsumer(processor);
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        return this.delegate.createPollingConsumer();
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        this.delegate.configureProperties(options);
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.delegate.setCamelContext(context);
    }

    @Override
    public boolean isLenientProperties() {
        return this.delegate.isLenientProperties();
    }

    @Override
    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startServices(this.detour, this.delegate);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopServices(this.delegate, this.detour);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

