/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.processor.UnitOfWorkProducer;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.servicemix.camel.CamelComponent;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiEndpoint;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.id.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiComponent
extends DefaultComponent {
    private CamelComponent camelJbiComponent;
    private CamelContext camelContext;
    private IdGenerator idGenerator;
    private String suName;

    public JbiComponent(CamelComponent component) {
        this.setCamelJbiComponent(component);
    }

    protected JbiComponent() {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public final void setCamelJbiComponent(CamelComponent component) {
        this.camelJbiComponent = component;
        this.camelJbiComponent.addJbiComponent(this);
    }

    public CamelComponent getCamelJbiComponent() {
        return this.camelJbiComponent;
    }

    public void setSuName(String su) {
        this.suName = su;
    }

    public String getSuName() {
        return this.suName;
    }

    public Endpoint createEndpoint(String uri) {
        if (uri.startsWith("jbi:")) {
            if ((uri = uri.substring("jbi:".length())).startsWith("//")) {
                uri = uri.substring("//".length());
            }
            return new JbiEndpoint(this, uri);
        }
        return null;
    }

    protected CamelProviderEndpoint createJbiEndpointFromCamel(Endpoint camelEndpoint, AsyncProcessor processor) {
        CamelProviderEndpoint jbiEndpoint;
        String endpointUri = camelEndpoint.getEndpointUri();
        if (camelEndpoint instanceof JbiEndpoint) {
            QName service = null;
            String endpoint = null;
            if (endpointUri.startsWith("name:")) {
                endpoint = endpointUri.substring("name:".length());
                service = CamelProviderEndpoint.SERVICE_NAME;
            } else if (endpointUri.startsWith("endpoint:")) {
                String[] parts;
                String uri = endpointUri.substring("endpoint:".length());
                try {
                    parts = URIResolver.split3((String)uri);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Expected syntax jbi:endpoint:[serviceNamespace][sep][serviceName][sep][endpointName] where sep = '/' or ':' depending on the serviceNamespace, but was given: " + endpointUri + ". Cause: " + e, e);
                }
                service = new QName(parts[0], parts[1]);
                endpoint = parts[2];
            } else if (endpointUri.startsWith("service:")) {
                String[] parts;
                String uri = endpointUri.substring("service:".length());
                try {
                    parts = URIResolver.split2((String)uri);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Expected syntax jbi:endpoint:[serviceNamespace][sep][serviceName] where sep = '/' or ':' depending on the serviceNamespace, but was given: " + endpointUri + ". Cause: " + e, e);
                }
                service = new QName(parts[0], parts[1]);
                endpoint = this.createEndpointName();
            } else {
                throw new IllegalArgumentException("Expected syntax jbi:endpoint:[serviceNamespace][sep][serviceName][sep][endpointName] or jbi:service:[serviceNamespace][sep][serviceName or jbi:name:[endpointName] but was given: " + endpointUri);
            }
            jbiEndpoint = new CamelProviderEndpoint(this.getCamelJbiComponent().getServiceUnit(), service, endpoint, this.createBinding(camelEndpoint), processor);
        } else {
            jbiEndpoint = new CamelProviderEndpoint(this.getCamelJbiComponent().getServiceUnit(), camelEndpoint, this.createBinding(camelEndpoint), processor);
        }
        jbiEndpoint.setCamelEndpoint(camelEndpoint);
        return jbiEndpoint;
    }

    protected JbiBinding createBinding(Endpoint camelEndpoint) {
        if (camelEndpoint instanceof JbiEndpoint) {
            return ((JbiEndpoint)camelEndpoint).createBinding();
        }
        return new JbiBinding(this.camelContext);
    }

    protected String createEndpointName() {
        if (this.idGenerator == null) {
            this.idGenerator = new IdGenerator("camel");
        }
        return this.idGenerator.generateSanitizedId();
    }

    public CamelProviderEndpoint createJbiEndpointFromCamel(Endpoint camelEndpoint) {
        AsyncProcessor processor = this.createCamelProcessor(camelEndpoint);
        return this.createJbiEndpointFromCamel(camelEndpoint, processor);
    }

    protected AsyncProcessor createCamelProcessor(Endpoint camelEndpoint) {
        AsyncProcessor processor = null;
        try {
            processor = AsyncProcessorConverterHelper.convert((Processor)new UnitOfWorkProducer(camelEndpoint.createProducer()));
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(camelEndpoint, (Throwable)e);
        }
        return processor;
    }

    protected Endpoint createEndpoint(String arg0, String arg1, Map<String, Object> arg2) throws Exception {
        return this.createEndpoint(arg0);
    }
}

