/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.Traceable;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.EmptyProducerCache;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingSlip
extends ServiceSupport
implements AsyncProcessor,
Traceable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ProducerCache producerCache;
    protected int cacheSize;
    protected boolean ignoreInvalidEndpoints;
    protected String header;
    protected Expression expression;
    protected String uriDelimiter;
    protected final CamelContext camelContext;

    public RoutingSlip(CamelContext camelContext) {
        ObjectHelper.notNull(camelContext, "camelContext");
        this.camelContext = camelContext;
    }

    public RoutingSlip(CamelContext camelContext, Expression expression, String uriDelimiter) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(expression, "expression");
        this.camelContext = camelContext;
        this.expression = expression;
        this.uriDelimiter = uriDelimiter;
        this.header = null;
    }

    public void setDelimiter(String delimiter) {
        this.uriDelimiter = delimiter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String toString() {
        return "RoutingSlip[expression=" + this.expression + " uriDelimiter=" + this.uriDelimiter + "]";
    }

    @Override
    public String getTraceLabel() {
        return "routingSlip[" + this.expression + "]";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException(new IllegalStateException("RoutingSlip has not been started: " + this));
            callback.done(true);
            return true;
        }
        return this.doRoutingSlip(exchange, callback);
    }

    public boolean doRoutingSlip(Exchange exchange, Object routingSlip, AsyncCallback callback) {
        this.expression = routingSlip instanceof Expression ? (Expression)routingSlip : ExpressionBuilder.constantExpression(routingSlip);
        return this.doRoutingSlip(exchange, callback);
    }

    protected RoutingSlipIterator createRoutingSlipIterator(Exchange exchange) throws Exception {
        Object slip = this.expression.evaluate(exchange, Object.class);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        final Iterator<Object> delegate = ObjectHelper.createIterator(slip, this.uriDelimiter);
        return new RoutingSlipIterator(){

            @Override
            public boolean hasNext(Exchange exchange) {
                return delegate.hasNext();
            }

            @Override
            public Object next(Exchange exchange) {
                return delegate.next();
            }
        };
    }

    private boolean doRoutingSlip(Exchange exchange, AsyncCallback callback) {
        RoutingSlipIterator iter;
        Exchange current = exchange;
        try {
            iter = this.createRoutingSlipIterator(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        if (current.hasProperties()) {
            current.setProperty("CamelSlipEndpoint", null);
        }
        while (iter.hasNext(current)) {
            FailedToCreateProducerException e;
            Endpoint endpoint;
            try {
                endpoint = this.resolveEndpoint(iter, exchange);
                if (endpoint == null) {
                    continue;
                }
            }
            catch (Exception e2) {
                current.setException(e2);
                break;
            }
            Exchange copy = this.prepareExchangeForRoutingSlip(current, endpoint);
            boolean sync = this.processExchange(endpoint, copy, exchange, callback, iter);
            current = copy;
            if (!sync) {
                this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                return false;
            }
            this.log.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
            if (this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", (Throwable)e);
                }
                current.setException(null);
            }
            if (PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", this.log)) continue;
            break;
        }
        this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)current);
        ExchangeHelper.copyResults(exchange, current);
        callback.done(true);
        return true;
    }

    protected Endpoint resolveEndpoint(RoutingSlipIterator iter, Exchange exchange) throws Exception {
        Object nextRecipient = iter.next(exchange);
        Endpoint endpoint = null;
        try {
            endpoint = ExchangeHelper.resolveEndpoint(exchange, nextRecipient);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoints()) {
                this.log.info("Endpoint uri is invalid: " + nextRecipient + ". This exception will be ignored.", (Throwable)e);
            }
            throw e;
        }
        return endpoint;
    }

    protected Exchange prepareExchangeForRoutingSlip(Exchange current, Endpoint endpoint) {
        DefaultExchange copy = new DefaultExchange(current);
        copy.setExchangeId(current.getExchangeId());
        this.copyOutToIn(copy, current);
        MessageHelper.resetStreamCache(copy.getIn());
        return copy;
    }

    protected boolean processExchange(final Endpoint endpoint, Exchange exchange, final Exchange original, AsyncCallback callback, final RoutingSlipIterator iter) {
        this.log.trace("Processing exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        boolean sync = this.producerCache.doInAsyncProducer(endpoint, exchange, null, callback, new AsyncProducerCallback(){

            @Override
            public boolean doInAsyncProducer(Producer producer, AsyncProcessor asyncProducer, final Exchange exchange, ExchangePattern exchangePattern, final AsyncCallback callback) {
                exchange.setProperty("CamelToEndpoint", endpoint.getEndpointUri());
                exchange.setProperty("CamelSlipEndpoint", endpoint.getEndpointUri());
                return asyncProducer.process(exchange, new AsyncCallback(){

                    @Override
                    public void done(boolean doneSync) {
                        if (doneSync) {
                            callback.done(doneSync);
                            return;
                        }
                        Exchange current = exchange;
                        while (iter.hasNext(current)) {
                            Endpoint endpoint;
                            FailedToCreateProducerException e;
                            if (RoutingSlip.this.isIgnoreInvalidEndpoints() && (e = current.getException(FailedToCreateProducerException.class)) != null) {
                                if (RoutingSlip.this.log.isDebugEnabled()) {
                                    RoutingSlip.this.log.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", (Throwable)e);
                                }
                                current.setException(null);
                            }
                            if (!PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", RoutingSlip.this.log)) break;
                            try {
                                endpoint = RoutingSlip.this.resolveEndpoint(iter, exchange);
                                if (endpoint == null) {
                                    continue;
                                }
                            }
                            catch (Exception e2) {
                                exchange.setException(e2);
                                break;
                            }
                            Exchange copy = RoutingSlip.this.prepareExchangeForRoutingSlip(current, endpoint);
                            boolean sync = RoutingSlip.this.processExchange(endpoint, copy, original, callback, iter);
                            current = copy;
                            if (sync) continue;
                            RoutingSlip.this.log.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)original.getExchangeId());
                            return;
                        }
                        RoutingSlip.this.log.trace("Processing complete for exchangeId: {} >>> {}", (Object)original.getExchangeId(), (Object)current);
                        ExchangeHelper.copyResults(original, current);
                        callback.done(false);
                    }
                });
            }
        });
        return sync;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache(this, this.camelContext);
                this.log.debug("RoutingSlip {} is not using ProducerCache", (Object)this);
            } else if (this.cacheSize == 0) {
                this.producerCache = new ProducerCache(this, this.camelContext);
                this.log.debug("RoutingSlip {} using ProducerCache with default cache size", (Object)this);
            } else {
                this.producerCache = new ProducerCache((Object)this, this.camelContext, this.cacheSize);
                this.log.debug("RoutingSlip {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.producerCache);
    }

    private Message getResultMessage(Exchange exchange) {
        if (exchange.hasOut()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    private void copyOutToIn(Exchange result, Exchange source) {
        result.setException(source.getException());
        result.setIn(this.getResultMessage(source));
        result.getProperties().clear();
        result.getProperties().putAll(source.getProperties());
    }

    protected static interface RoutingSlipIterator {
        public boolean hasNext(Exchange var1);

        public Object next(Exchange var1);
    }
}

