/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class UseOriginalAggregationStrategy
implements AggregationStrategy {
    private final Exchange original;
    private final boolean propagateException;

    public UseOriginalAggregationStrategy() {
        this(null, true);
    }

    public UseOriginalAggregationStrategy(Exchange original, boolean propagateException) {
        this.original = original;
        this.propagateException = propagateException;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Exception exception;
        if (this.propagateException && (exception = this.checkException(oldExchange, newExchange)) != null) {
            this.original.setException(exception);
        }
        return this.original != null ? this.original : oldExchange;
    }

    protected Exception checkException(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange.getException();
        }
        return newExchange != null && newExchange.getException() != null ? newExchange.getException() : oldExchange.getException();
    }

    public String toString() {
        return "UseOriginalAggregationStrategy";
    }
}

