/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.servicemix.camel.CamelConsumerEndpoint;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.camel.CamelSpringDeployer;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiEndpoint;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.IntrospectionSupport;
import org.apache.servicemix.jbi.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelJbiComponent
extends DefaultComponent
implements Component<Exchange> {
    protected CamelSpringDeployer deployer;
    private JbiBinding binding;
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;
    private IdGenerator idGenerator;

    public BaseServiceUnitManager createServiceUnitManager() {
        Deployer[] deployers = new Deployer[]{new CamelSpringDeployer(this)};
        return new BaseServiceUnitManager((ServiceMixComponent)this, deployers);
    }

    protected List<CamelProviderEndpoint> getConfiguredEndpoints() {
        return new ArrayList<CamelProviderEndpoint>();
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{CamelProviderEndpoint.class, CamelConsumerEndpoint.class};
    }

    public JbiBinding getBinding() {
        if (this.binding == null) {
            this.binding = new JbiBinding();
        }
        return this.binding;
    }

    public void setBinding(JbiBinding binding) {
        this.binding = binding;
    }

    protected String[] getEPRProtocols() {
        return new String[]{"camel"};
    }

    protected org.apache.servicemix.common.Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        CamelProviderEndpoint endpoint = this.createEndpoint(ep);
        endpoint.activate();
        return endpoint;
    }

    public CamelProviderEndpoint createEndpoint(ServiceEndpoint ep) throws URISyntaxException {
        URI uri = new URI(ep.getEndpointName());
        Map map = URISupport.parseQuery((String)uri.getQuery());
        String camelUri = uri.getSchemeSpecificPart();
        Endpoint camelEndpoint = this.getCamelContext().getEndpoint(camelUri);
        Processor processor = this.createCamelProcessor(camelEndpoint);
        CamelProviderEndpoint endpoint = new CamelProviderEndpoint(this.getServiceUnit(), camelEndpoint, this.getBinding(), processor);
        IntrospectionSupport.setProperties((Object)((Object)endpoint), (Map)map);
        return endpoint;
    }

    public Endpoint<Exchange> createEndpoint(String uri) {
        if (uri.startsWith("jbi:")) {
            uri = uri.substring("jbi:".length());
            return new JbiEndpoint(this, uri);
        }
        return null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ScheduledThreadPoolExecutor(5);
        }
        return this.executorService;
    }

    public CamelProviderEndpoint activateJbiEndpoint(Endpoint camelEndpoint, Processor processor) throws Exception {
        CamelProviderEndpoint jbiEndpoint = this.createJbiEndpointFromCamel(camelEndpoint, processor);
        if (this.deployer != null) {
            this.deployer.addService(jbiEndpoint);
        } else {
            this.addEndpoint((org.apache.servicemix.common.Endpoint)jbiEndpoint);
        }
        return jbiEndpoint;
    }

    public void deactivateJbiEndpoint(CamelProviderEndpoint jbiEndpoint) throws Exception {
    }

    protected CamelProviderEndpoint createJbiEndpointFromCamel(Endpoint camelEndpoint, Processor processor) {
        CamelProviderEndpoint jbiEndpoint;
        String endpointUri = camelEndpoint.getEndpointUri();
        if (camelEndpoint instanceof JbiEndpoint) {
            QName service = null;
            String endpoint = null;
            if (endpointUri.startsWith("name:")) {
                endpoint = endpointUri.substring("name:".length());
                service = CamelProviderEndpoint.SERVICE_NAME;
            } else if (endpointUri.startsWith("endpoint:")) {
                String[] parts;
                String uri = endpointUri.substring("endpoint:".length());
                try {
                    parts = URIResolver.split3((String)uri);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Expected syntax jbi:endpoint:[serviceNamespace][sep][serviceName][sep][endpointName] where sep = '/' or ':' depending on the serviceNamespace, but was given: " + endpointUri + ". Cause: " + e, e);
                }
                service = new QName(parts[0], parts[1]);
                endpoint = parts[2];
            } else if (endpointUri.startsWith("service:")) {
                String[] parts;
                String uri = endpointUri.substring("service:".length());
                try {
                    parts = URIResolver.split2((String)uri);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Expected syntax jbi:endpoint:[serviceNamespace][sep][serviceName] where sep = '/' or ':' depending on the serviceNamespace, but was given: " + endpointUri + ". Cause: " + e, e);
                }
                service = new QName(parts[0], parts[1]);
                endpoint = this.createEndpointName();
            } else {
                throw new IllegalArgumentException("Expected syntax jbi:endpoint:[serviceNamespace][sep][serviceName][sep][endpointName] or jbi:service:[serviceNamespace][sep][serviceName or jbi:name:[endpointName] but was given: " + endpointUri);
            }
            jbiEndpoint = new CamelProviderEndpoint(this.getServiceUnit(), service, endpoint, camelEndpoint, this.getBinding(), processor);
        } else {
            jbiEndpoint = new CamelProviderEndpoint(this.getServiceUnit(), camelEndpoint, this.getBinding(), processor);
        }
        return jbiEndpoint;
    }

    protected String createEndpointName() {
        if (this.idGenerator == null) {
            this.idGenerator = new IdGenerator("camel");
        }
        return this.idGenerator.generateSanitizedId();
    }

    public CamelProviderEndpoint createJbiEndpointFromCamel(Endpoint camelEndpoint) {
        Processor processor = this.createCamelProcessor(camelEndpoint);
        return this.createJbiEndpointFromCamel(camelEndpoint, processor);
    }

    protected Processor createCamelProcessor(Endpoint camelEndpoint) {
        Producer processor = null;
        try {
            processor = camelEndpoint.createProducer();
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(camelEndpoint, (Throwable)e);
        }
        return processor;
    }

    public boolean isEndpointExposedOnNmr(Endpoint endpoint) {
        return false;
    }
}

