/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiExchange;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;

public class CamelProviderEndpoint
extends ProviderEndpoint {
    public static final QName SERVICE_NAME = new QName("http://activemq.apache.org/camel/schema/jbi", "provider");
    private Endpoint camelEndpoint;
    private JbiBinding binding;
    private Processor camelProcessor;

    public CamelProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint, Endpoint camelEndpoint, JbiBinding binding, Processor camelProcessor) {
        super(serviceUnit, service, endpoint);
        this.camelProcessor = camelProcessor;
        this.camelEndpoint = camelEndpoint;
        this.binding = binding;
    }

    public CamelProviderEndpoint(ServiceUnit serviceUnit, Endpoint camelEndpoint, JbiBinding binding, Processor camelProcessor) {
        this(serviceUnit, SERVICE_NAME, camelEndpoint.getEndpointUri(), camelEndpoint, binding, camelProcessor);
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
        } else {
            throw new IllegalStateException("Unsupported role: " + exchange.getRole());
        }
        this.handleActiveProviderExchange(exchange);
    }

    protected void handleActiveProviderExchange(MessageExchange exchange) throws Exception {
        if (exchange.getFault() != null) {
            this.done(exchange);
        } else if (exchange.getMessage("in") != null) {
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received exchange: " + exchange));
                }
                JbiExchange camelExchange = new JbiExchange(this.camelEndpoint.getCamelContext(), this.binding, exchange);
                this.camelProcessor.process((Exchange)camelExchange);
                if (camelExchange.isFailed()) {
                    Throwable t = camelExchange.getException();
                    Exception e = t == null ? new Exception("Unknown error") : (t instanceof Exception ? (Exception)t : new Exception(t));
                    this.fail(exchange, e);
                } else {
                    this.done(exchange);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received exchange: " + exchange));
                }
                JbiExchange camelExchange = new JbiExchange(this.camelEndpoint.getCamelContext(), this.binding, exchange);
                this.camelProcessor.process((Exchange)camelExchange);
                if (camelExchange.isFailed()) {
                    Throwable t = camelExchange.getException();
                    Exception e = t == null ? new Exception("Unknown error") : (t instanceof Exception ? (Exception)t : new Exception(t));
                    this.fail(exchange, e);
                } else {
                    boolean txSync;
                    boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
                    if (txSync) {
                        this.sendSync(exchange);
                    } else {
                        this.send(exchange);
                    }
                }
            }
        } else {
            throw new IllegalStateException("Provider exchange is ACTIVE, but no in or fault is provided");
        }
    }
}

