/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.servicemix.camel.JbiException;
import org.apache.servicemix.camel.JbiExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiMessage
extends DefaultMessage {
    private NormalizedMessage normalizedMessage;

    public JbiMessage() {
    }

    public JbiMessage(NormalizedMessage normalizedMessage) {
        this.normalizedMessage = normalizedMessage;
    }

    public String toString() {
        if (this.normalizedMessage != null) {
            return "JbiMessage: " + this.normalizedMessage;
        }
        return "JbiMessage: " + this.getBody();
    }

    public JbiExchange getExchange() {
        return (JbiExchange)super.getExchange();
    }

    public NormalizedMessage getNormalizedMessage() {
        return this.normalizedMessage;
    }

    public void setNormalizedMessage(NormalizedMessage normalizedMessage) {
        this.normalizedMessage = normalizedMessage;
    }

    public Object getHeader(String name) {
        Object answer = null;
        if (this.normalizedMessage != null) {
            answer = this.normalizedMessage.getProperty(name);
        }
        if (answer == null) {
            answer = super.getHeader(name);
        }
        return answer;
    }

    public void setHeader(String name, Object value) {
        if (this.normalizedMessage != null) {
            this.normalizedMessage.setProperty(name, value);
        } else {
            super.setHeader(name, value);
        }
    }

    public DataHandler getAttachment(String id) {
        DataHandler answer = null;
        if (this.normalizedMessage != null) {
            answer = this.normalizedMessage.getAttachment(id);
        }
        if (answer == null) {
            answer = super.getAttachment(id);
        }
        return answer;
    }

    public void addAttachment(String id, DataHandler content) {
        if (this.normalizedMessage != null) {
            try {
                this.normalizedMessage.addAttachment(id, content);
            }
            catch (MessagingException e) {
                throw new JbiException(e);
            }
        } else {
            super.addAttachment(id, content);
        }
    }

    public JbiMessage newInstance() {
        return new JbiMessage();
    }

    protected Object createBody() {
        JbiExchange jbiExchange;
        if (this.normalizedMessage != null && (jbiExchange = this.getExchange()) != null) {
            return jbiExchange.getBinding().extractBodyFromJbi(jbiExchange, this.normalizedMessage);
        }
        return null;
    }

    protected void populateInitialHeaders(Map<String, Object> map) {
        if (this.normalizedMessage != null) {
            Iterator iter = this.normalizedMessage.getPropertyNames().iterator();
            while (iter.hasNext()) {
                String name = iter.next().toString();
                Object value = this.normalizedMessage.getProperty(name);
                map.put(name, value);
            }
        }
    }

    protected void populateInitialAttachments(Map<String, DataHandler> map) {
        if (this.normalizedMessage != null) {
            Iterator iter = this.normalizedMessage.getAttachmentNames().iterator();
            while (iter.hasNext()) {
                String id = iter.next().toString();
                DataHandler content = this.normalizedMessage.getAttachment(id);
                map.put(id, content);
            }
        }
    }

    public void setBody(Object body) {
        Source source;
        if (this.normalizedMessage != null && (source = this.getExchange().getBinding().convertBodyToJbi((Exchange)this.getExchange(), body)) != null) {
            try {
                this.normalizedMessage.setContent(source);
            }
            catch (MessagingException e) {
                throw new JbiException(e);
            }
        }
        super.setBody(body);
    }
}

