/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedOutputStream
extends OutputStream {
    public static final String THRESHOLD = "CamelCachedOutputStreamThreshold";
    public static final String TEMP_DIR = "CamelCachedOutputStreamOutputDirectory";
    protected boolean outputLocked;
    protected OutputStream currentStream = new ByteArrayOutputStream(2048);
    private long threshold = 65536L;
    private int totalLength;
    private boolean inmem = true;
    private File tempFile;
    private File outputDir;

    public CachedOutputStream() {
    }

    public CachedOutputStream(long threshold) {
        this();
        this.threshold = threshold;
    }

    public CachedOutputStream(Map<String, String> properties) {
        this();
        File f;
        String value = properties.get(THRESHOLD);
        if (value != null) {
            this.threshold = Integer.parseInt(value);
        }
        this.outputDir = (value = properties.get(TEMP_DIR)) != null ? ((f = new File(value)).exists() && f.isDirectory() ? f : null) : null;
    }

    protected void doFlush() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
        this.doFlush();
    }

    protected void doClose() throws IOException {
    }

    protected void postClose() throws IOException {
    }

    public void lockOutputStream() throws IOException {
        this.currentStream.flush();
        this.outputLocked = true;
    }

    @Override
    public void close() throws IOException {
        this.currentStream.flush();
        this.doClose();
        this.currentStream.close();
        this.maybeDeleteTempFile(this.currentStream);
        this.postClose();
    }

    public boolean equals(Object obj) {
        return this.currentStream.equals(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetOut(OutputStream out, boolean copyOldContent) throws IOException {
        if (out == null) {
            out = new ByteArrayOutputStream();
        }
        if (this.currentStream instanceof CachedOutputStream) {
            CachedOutputStream ac = (CachedOutputStream)this.currentStream;
            InputStream in = ac.getInputStream();
            IOHelper.copyAndCloseInput(in, out);
        } else if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.currentStream;
            if (copyOldContent && byteOut.size() > 0) {
                byteOut.writeTo(out);
            }
        } else {
            this.currentStream.close();
            FileInputStream fin = new FileInputStream(this.tempFile);
            if (copyOldContent) {
                IOHelper.copyAndCloseInput(fin, out);
            }
            this.tempFile.delete();
            this.tempFile = null;
            this.inmem = true;
        }
        this.currentStream = out;
        this.outputLocked = false;
    }

    public static void copyStream(InputStream in, OutputStream out, int bufferSize) throws IOException {
        IOHelper.copyAndCloseInput(in, out, bufferSize);
    }

    public int size() {
        return this.totalLength;
    }

    public byte[] getBytes() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.currentStream).toByteArray();
            }
            throw new IOException("Unknown format of currentStream");
        }
        FileInputStream fin = new FileInputStream(this.tempFile);
        return IOConverter.toBytes(fin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(OutputStream out) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            ((ByteArrayOutputStream)this.currentStream).writeTo(out);
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            IOHelper.copyAndCloseInput(fin, out);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out, int limit) throws IOException {
        this.flush();
        if (this.totalLength < limit || limit == -1) {
            this.writeCacheTo(out);
            return;
        }
        int count = 0;
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            byte[] bytes = ((ByteArrayOutputStream)this.currentStream).toByteArray();
            out.append(IOHelper.newStringFromBytes(bytes, 0, limit));
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            byte[] bytes = new byte[1024];
            int x = fin.read(bytes);
            while (x != -1) {
                if (count + x > limit) {
                    x = limit - count;
                }
                out.append(IOHelper.newStringFromBytes(bytes, 0, x));
                if ((count += x) >= limit) {
                    x = -1;
                    continue;
                }
                x = fin.read(bytes);
            }
            fin.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(StringBuilder out) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            byte[] bytes = ((ByteArrayOutputStream)this.currentStream).toByteArray();
            out.append(IOHelper.newStringFromBytes(bytes));
            return;
        } else {
            FileInputStream fin = new FileInputStream(this.tempFile);
            byte[] bytes = new byte[1024];
            int x = fin.read(bytes);
            while (x != -1) {
                out.append(IOHelper.newStringFromBytes(bytes, 0, x));
                x = fin.read(bytes);
            }
            fin.close();
        }
    }

    public OutputStream getOut() {
        return this.currentStream;
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(CachedOutputStream.class.getName()).append(" Content: ");
        try {
            this.writeCacheTo(builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.append("]").toString();
    }

    protected void onWrite() throws IOException {
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += len;
            if (this.threshold > 0L && this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
                this.createFileOutputStream();
            }
            this.currentStream.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            this.totalLength += b.length;
            if (this.threshold > 0L && this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
                this.createFileOutputStream();
            }
            this.currentStream.write(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.outputLocked) {
            this.onWrite();
            ++this.totalLength;
            if (this.threshold > 0L && this.inmem && (long)this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
                this.createFileOutputStream();
            }
            this.currentStream.write(b);
        }
    }

    private void createFileOutputStream() throws IOException {
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        this.tempFile = this.outputDir == null ? FileUtil.createTempFile("cos", ".tmp") : FileUtil.createTempFile("cos", ".tmp", this.outputDir, false);
        this.currentStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        bout.writeTo(this.currentStream);
        this.inmem = false;
    }

    public File getTempFile() {
        return this.tempFile != null && this.tempFile.exists() ? this.tempFile : null;
    }

    public InputStream getInputStream() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.tempFile){

                public void close() throws IOException {
                    super.close();
                    CachedOutputStream.this.maybeDeleteTempFile(this);
                }
            };
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file was deleted, " + e.toString());
        }
    }

    public StreamCache getStreamCache() throws IOException {
        this.flush();
        if (this.inmem) {
            if (this.currentStream instanceof ByteArrayOutputStream) {
                return new InputStreamCache(((ByteArrayOutputStream)this.currentStream).toByteArray());
            }
            return null;
        }
        try {
            FileInputStreamCache fileInputStream = new FileInputStreamCache(this.tempFile, this);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cached file was deleted, " + e.toString());
        }
    }

    private void maybeDeleteTempFile(Object stream) {
        if (!this.inmem && this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
            this.currentStream = new ByteArrayOutputStream(1024);
            this.inmem = true;
        }
    }

    public void setOutputDir(File outputDir) throws IOException {
        this.outputDir = outputDir;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }
}

