/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamCache;

public class FileInputStreamCache
extends InputStream
implements StreamCache {
    private FileInputStream inputStream;
    private CachedOutputStream cachedOutputStream;
    private File file;

    public FileInputStreamCache(File file, CachedOutputStream cos) throws FileNotFoundException {
        this.file = file;
        this.cachedOutputStream = cos;
        this.inputStream = new FileInputStream(file);
    }

    public void close() {
        try {
            this.inputStream.close();
            this.cachedOutputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeCamelException(exception);
        }
    }

    public void reset() {
        try {
            this.inputStream.close();
            this.inputStream = new FileInputStream(this.file);
        }
        catch (Exception exception) {
            throw new RuntimeCamelException(exception);
        }
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }
}

