/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.util.UuidGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageSupport
implements Message {
    private static final UuidGenerator DEFALT_ID_GENERATOR = new UuidGenerator();
    private Exchange exchange;
    private Object body;
    private String messageId;

    @Override
    public Object getBody() {
        if (this.body == null) {
            this.body = this.createBody();
        }
        return this.body;
    }

    @Override
    public <T> T getBody(Class<T> type) {
        return this.getBody(type, this.getBody());
    }

    protected <T> T getBody(Class<T> type, Object body) {
        CamelContext camelContext;
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        Exchange e = this.getExchange();
        if (e != null && (camelContext = e.getContext()) != null) {
            boolean tryConvert = true;
            TypeConverter converter = camelContext.getTypeConverter();
            if (body != null) {
                boolean bl = tryConvert = !this.hasNoConverterFor(converter, type, body.getClass());
            }
            if (tryConvert) {
                try {
                    return converter.convertTo(type, e, body);
                }
                catch (NoTypeConversionAvailableException ex) {
                    // empty catch block
                }
            }
            boolean bl = tryConvert = !this.hasNoConverterFor(converter, type, this.getClass());
            if (tryConvert) {
                try {
                    return converter.convertTo(type, e, this);
                }
                catch (NoTypeConversionAvailableException ex) {
                    // empty catch block
                }
            }
        }
        throw new NoTypeConversionAvailableException(body, type);
    }

    private boolean hasNoConverterFor(TypeConverter converter, Class toType, Class fromType) {
        if (converter instanceof DefaultTypeConverter) {
            DefaultTypeConverter defaultTypeConverter = (DefaultTypeConverter)converter;
            return defaultTypeConverter.hasNoConverterFor(toType, fromType);
        }
        return false;
    }

    @Override
    public void setBody(Object body) {
        this.body = body;
    }

    @Override
    public <T> void setBody(Object value, Class<T> type) {
        T v;
        Exchange e = this.getExchange();
        if (e != null && (v = e.getContext().getTypeConverter().convertTo(type, e, value)) != null) {
            value = v;
        }
        this.setBody(value);
    }

    @Override
    public Message copy() {
        Message answer = this.newInstance();
        answer.copyFrom(this);
        return answer;
    }

    @Override
    public void copyFrom(Message that) {
        if (this == that) {
            return;
        }
        this.setMessageId(that.getMessageId());
        this.setBody(that.getBody());
        this.getHeaders().clear();
        this.getHeaders().putAll(that.getHeaders());
        this.getAttachments().clear();
        this.getAttachments().putAll(that.getAttachments());
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public abstract Message newInstance();

    protected Object createBody() {
        return null;
    }

    @Override
    public String getMessageId() {
        if (this.messageId == null) {
            this.messageId = this.createMessageId();
        }
        return this.messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    protected String createMessageId() {
        return DEFALT_ID_GENERATOR.generateId();
    }
}

