/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.management.ManagedEndpoint;
import org.apache.camel.management.ManagedRoute;
import org.apache.camel.management.ManagedService;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelNamingStrategy {
    public static final String VALUE_UNKNOWN = "unknown";
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_CONTEXT = "context";
    public static final String KEY_GROUP = "group";
    public static final String KEY_ROUTE = "route";
    public static final String KEY_NODE_ID = "nodeid";
    public static final String TYPE_CONTEXT = "context";
    public static final String TYPE_ENDPOINT = "endpoints";
    public static final String TYPE_PROCESSOR = "processors";
    public static final String TYPE_CONSUMER = "consumers";
    public static final String TYPE_ROUTE = "routes";
    protected String domainName;
    protected String hostName = "locahost";

    public CamelNamingStrategy() {
        this("org.apache.camel");
    }

    public CamelNamingStrategy(String domainName) {
        if (domainName != null) {
            this.domainName = domainName;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public ObjectName getObjectName(CamelContext context) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("name=").append("context");
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(ManagedEndpoint mbean) throws MalformedObjectNameException {
        Endpoint<? extends Exchange> ep = mbean.getEndpoint();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(ep.getCamelContext())).append(",");
        buffer.append("type=endpoints,");
        buffer.append("name=").append(ObjectName.quote(this.getEndpointId(ep)));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(CamelContext context, ManagedService mbean) throws MalformedObjectNameException {
        Service service = mbean.getService();
        if (!(service instanceof Consumer)) {
            return null;
        }
        String serviceBranch = TYPE_CONSUMER;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=" + serviceBranch + ",");
        buffer.append("name=").append(service.getClass().getSimpleName()).append("(0x").append(Integer.toHexString(mbean.getService().hashCode())).append(")");
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(ManagedRoute mbean) throws MalformedObjectNameException {
        Route<? extends Exchange> route = mbean.getRoute();
        Endpoint<? extends Exchange> ep = route.getEndpoint();
        String id = (String)route.getProperties().get("id");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(ep.getCamelContext())).append(",");
        buffer.append("type=routes,");
        buffer.append("name=").append(ObjectName.quote(id == null ? "0x" + Integer.toHexString(route.hashCode()) : id));
        return this.createObjectName(buffer);
    }

    public ObjectName getObjectName(RouteContext routeContext, ProcessorType processor) throws MalformedObjectNameException {
        Endpoint<? extends Exchange> ep = routeContext.getEndpoint();
        String ctxid = ep != null ? this.getContextId(ep.getCamelContext()) : VALUE_UNKNOWN;
        String cid = ObjectName.quote(ep.getEndpointUri());
        String nodeId = processor.idOrCreate();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(ctxid).append(",");
        buffer.append("type=processors,");
        buffer.append("nodeid=").append(nodeId).append(",");
        buffer.append("name=").append(ObjectName.quote(processor.toString()));
        return this.createObjectName(buffer);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    protected String getContextId(CamelContext context) {
        return this.hostName + "/" + (context != null ? context.getName() : VALUE_UNKNOWN);
    }

    protected String getEndpointId(Endpoint<? extends Exchange> ep) {
        String id;
        String uri = ep.getEndpointUri();
        int pos = uri.indexOf(63);
        String string = id = pos == -1 ? uri : uri.substring(0, pos);
        if (!ep.isSingleton()) {
            id = id + "?id=0x" + Integer.toHexString(ep.hashCode());
        }
        return id;
    }

    protected ObjectName createObjectName(StringBuffer buffer) throws MalformedObjectNameException {
        String text = buffer.toString();
        try {
            return new ObjectName(text);
        }
        catch (MalformedObjectNameException e) {
            throw new MalformedObjectNameException("Could not create ObjectName from: " + text + ". Reason: " + e);
        }
    }
}

