/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.ProceedType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.StopType;
import org.apache.camel.model.WhenType;
import org.apache.camel.processor.Interceptor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="intercept")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InterceptType
extends OutputType<ProcessorType> {
    @XmlTransient
    private ProceedType proceed = new ProceedType();
    @XmlTransient
    private Boolean stopIntercept = Boolean.FALSE;
    @XmlTransient
    private Boolean usePredicate = Boolean.FALSE;

    public String toString() {
        return "Intercept[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "intercept";
    }

    @Override
    public String getLabel() {
        return "intercept";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Interceptor interceptor = new Interceptor();
        routeContext.intercept(interceptor);
        Processor interceptRoute = this.createOutputsProcessor(routeContext);
        interceptor.setInterceptorLogic(interceptRoute);
        return interceptor;
    }

    public ChoiceType when(Predicate predicate) {
        this.usePredicate = Boolean.TRUE;
        ChoiceType choice = this.choice().when(PredicateBuilder.not(predicate));
        choice.addOutput(this.proceed);
        return choice.otherwise();
    }

    public ProceedType getProceed() {
        return this.proceed;
    }

    public void stopIntercept() {
        this.setStopIntercept(Boolean.TRUE);
    }

    public void afterPropertiesSet() {
        ArrayList<ProcessorType> list = new ArrayList<ProcessorType>();
        for (ProcessorType out : this.outputs) {
            if (out instanceof WhenType) {
                WhenType when = (WhenType)out;
                this.usePredicate = Boolean.TRUE;
                ChoiceType choice = new ChoiceType();
                choice.when(PredicateBuilder.not(when.getExpression()));
                choice.addOutput(this.proceed);
                list.add(choice);
                ChoiceType otherwise = choice.otherwise();
                for (ProcessorType<?> child : when.getOutputs()) {
                    if (child instanceof StopType) {
                        this.stopIntercept();
                        continue;
                    }
                    otherwise.addOutput(child);
                }
                continue;
            }
            if (out instanceof StopType) {
                this.stopIntercept();
                continue;
            }
            list.add(out);
        }
        this.outputs.clear();
        for (ProcessorType out : list) {
            this.addOutput(out);
        }
    }

    public InterceptType createProxy() {
        InterceptType answer = new InterceptType();
        answer.getOutputs().addAll(this.getOutputs());
        answer.setStopIntercept(this.getStopIntercept());
        if (answer.getOutputs().size() > 0) {
            ChoiceType choice = null;
            for (ProcessorType<?> processor : answer.getOutputs()) {
                if (!(processor instanceof ChoiceType)) continue;
                choice = (ChoiceType)processor;
                if (this.usePredicate.booleanValue() && this.getStopIntercept().booleanValue()) {
                    WhenType when = choice.getWhenClauses().get(0);
                    when.getOutputs().remove(this.getProceed());
                }
                this.addProceedProxy(this.getProceed(), answer.getProceed(), choice.getWhenClauses().get(choice.getWhenClauses().size() - 1), this.usePredicate != false && this.getStopIntercept() == false);
                this.addProceedProxy(this.getProceed(), answer.getProceed(), choice.getOtherwise(), this.getStopIntercept() == false);
                if (!this.getStopIntercept().booleanValue()) break;
                this.addProceedProxy(this.getProceed(), answer.getProceed(), choice.getWhenClauses().get(choice.getWhenClauses().size() - 1), this.usePredicate);
                break;
            }
            if (choice == null) {
                this.addProceedProxy(this.getProceed(), answer.getProceed(), answer, this.getStopIntercept() == false);
            }
        }
        return answer;
    }

    private void addProceedProxy(ProceedType orig, ProceedType proxy, ProcessorType<?> processor, boolean force) {
        int index = processor.getOutputs().indexOf(orig);
        if (index >= 0) {
            processor.addOutput(proxy);
            List<ProcessorType<?>> outs = processor.getOutputs();
            outs.remove(proxy);
            outs.set(index, proxy);
        } else if (force) {
            processor.addOutput(proxy);
        }
    }

    public void setStopIntercept(Boolean stop) {
        this.stopIntercept = stop;
    }

    public Boolean getStopIntercept() {
        return this.stopIntercept;
    }
}

