/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProcessor
extends ServiceSupport
implements Processor {
    public static final long DEFAULT_BATCH_TIMEOUT = 1000L;
    public static final int DEFAULT_BATCH_SIZE = 100;
    private long batchTimeout = 1000L;
    private int batchSize = 100;
    private int outBatchSize;
    private Processor processor;
    private Collection<Exchange> collection;
    private ExceptionHandler exceptionHandler;
    private BatchSender sender;

    public BatchProcessor(Processor processor, Collection<Exchange> collection) {
        this.processor = processor;
        this.collection = collection;
        this.sender = new BatchSender();
    }

    public String toString() {
        return "BatchProcessor[to: " + this.processor + "]";
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize <= 0 ? Integer.MAX_VALUE : batchSize;
    }

    public int getOutBatchSize() {
        return this.outBatchSize;
    }

    public void setOutBatchSize(int outBatchSize) {
        this.outBatchSize = outBatchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    private boolean isInBatchCompleted(int num) {
        return num >= this.batchSize;
    }

    private boolean isOutBatchCompleted() {
        if (this.outBatchSize == 0) {
            return true;
        }
        return this.collection.size() > 0 && this.collection.size() >= this.outBatchSize;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
        this.sender.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.sender.cancel();
        ServiceHelper.stopServices(this.processor);
        this.collection.clear();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.sender.enqueueExchange(exchange);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BatchSender
    extends Thread {
        private Queue<Exchange> queue;
        private Lock queueLock;
        private boolean exchangeEnqueued;
        private Condition exchangeEnqueuedCondition;

        public BatchSender() {
            super("Batch Sender");
            this.queueLock = new ReentrantLock();
            this.exchangeEnqueuedCondition = this.queueLock.newCondition();
            this.queue = new LinkedList<Exchange>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.queueLock.lock();
            try {
                try {}
                catch (InterruptedException e) {
                    this.queueLock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                this.queueLock.unlock();
                throw throwable;
            }
            while (true) {
                if (!this.exchangeEnqueued) {
                    this.exchangeEnqueuedCondition.await(BatchProcessor.this.batchTimeout, TimeUnit.MILLISECONDS);
                }
                if (!this.exchangeEnqueued) {
                    this.drainQueueTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize);
                } else {
                    this.exchangeEnqueued = false;
                    while (BatchProcessor.this.isInBatchCompleted(this.queue.size())) {
                        this.drainQueueTo(BatchProcessor.this.collection, BatchProcessor.this.batchSize);
                    }
                    if (!BatchProcessor.this.isOutBatchCompleted()) continue;
                }
                this.queueLock.unlock();
                try {
                    try {
                        this.sendExchanges();
                    }
                    catch (Exception e) {
                        BatchProcessor.this.getExceptionHandler().handleException(e);
                    }
                    continue;
                }
                finally {
                    this.queueLock.lock();
                    continue;
                }
                break;
            }
        }

        private void drainQueueTo(Collection<Exchange> collection, int batchSize) {
            Exchange e;
            for (int i = 0; i < batchSize && (e = this.queue.poll()) != null; ++i) {
                collection.add(e);
            }
        }

        public void cancel() {
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueueExchange(Exchange exchange) {
            this.queueLock.lock();
            try {
                this.queue.add(exchange);
                this.exchangeEnqueued = true;
                this.exchangeEnqueuedCondition.signal();
            }
            finally {
                this.queueLock.unlock();
            }
        }

        private void sendExchanges() throws Exception {
            Iterator iter = BatchProcessor.this.collection.iterator();
            while (iter.hasNext()) {
                Exchange exchange = (Exchange)iter.next();
                iter.remove();
                BatchProcessor.this.processExchange(exchange);
            }
        }
    }
}

