/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopProcessor
extends DelegateProcessor {
    public static final String PROP_ITER_COUNT = "CamelIterationCount";
    public static final String PROP_ITER_INDEX = "CamelIterationIndex";
    private static final Log LOG = LogFactory.getLog(LoopProcessor.class);
    private Expression<Exchange> expression;

    public LoopProcessor(Expression<Exchange> expression, Processor processor) {
        super(processor);
        this.expression = expression;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String text = ExchangeHelper.convertToType(exchange, String.class, this.expression.evaluate(exchange));
        Integer value = ExchangeHelper.convertToType(exchange, Integer.class, text);
        if (value == null) {
            throw new RuntimeCamelException("Expression \"" + this.expression + "\" does not evaluate to an int.");
        }
        int count = value;
        exchange.setProperty(PROP_ITER_COUNT, count);
        for (int i = 0; i < count; ++i) {
            LOG.debug((Object)("LoopProcessor: iteration #" + i));
            exchange.setProperty(PROP_ITER_INDEX, i);
            super.process(exchange);
        }
    }

    @Override
    public String toString() {
        return "Loop[for: " + this.expression + " times do: " + this.getProcessor() + "]";
    }

    public Expression<Exchange> getExpression() {
        return this.expression;
    }
}

