/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.util.AsyncProcessorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadProcessor
implements AsyncProcessor,
Service {
    private ThreadPoolExecutor executor;
    private long stackSize;
    private ThreadGroup threadGroup;
    private int priority = 5;
    private boolean daemon = true;
    private String name = "Thread Processor";
    private BlockingQueue<Runnable> taskQueue;
    private long keepAliveTime;
    private int maxSize = 1;
    private int coreSize = 1;
    private final AtomicBoolean shutdown = new AtomicBoolean(true);
    private boolean callerRunsWhenRejected = true;

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("ThreadProcessor is not running.");
        }
        ProcessCall call = new ProcessCall(exchange, callback);
        try {
            this.executor.execute(call);
            return false;
        }
        catch (RejectedExecutionException e) {
            if (this.callerRunsWhenRejected) {
                if (this.shutdown.get()) {
                    exchange.setException(new RejectedExecutionException());
                } else {
                    callback.done(true);
                }
            } else {
                exchange.setException(e);
            }
            return true;
        }
    }

    @Override
    public void start() throws Exception {
        this.shutdown.set(false);
        this.getExecutor();
    }

    @Override
    public void stop() throws Exception {
        this.shutdown.set(true);
        this.executor.shutdown();
        this.executor.awaitTermination(0L, TimeUnit.SECONDS);
    }

    public long getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(long stackSize) {
        this.stackSize = stackSize;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public void setCoreSize(int coreSize) {
        this.coreSize = coreSize;
    }

    public BlockingQueue<Runnable> getTaskQueue() {
        if (this.taskQueue == null) {
            this.taskQueue = new ArrayBlockingQueue<Runnable>(1000);
        }
        return this.taskQueue;
    }

    public void setTaskQueue(BlockingQueue<Runnable> taskQueue) {
        this.taskQueue = taskQueue;
    }

    public ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(this.getCoreSize(), this.getMaxSize(), this.getKeepAliveTime(), TimeUnit.MILLISECONDS, this.getTaskQueue(), new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = ThreadProcessor.this.getStackSize() > 0L ? new Thread(ThreadProcessor.this.getThreadGroup(), runnable, ThreadProcessor.this.getName(), ThreadProcessor.this.getStackSize()) : new Thread(ThreadProcessor.this.getThreadGroup(), runnable, ThreadProcessor.this.getName());
                    thread.setDaemon(ThreadProcessor.this.isDaemon());
                    thread.setPriority(ThreadProcessor.this.getPriority());
                    return thread;
                }
            });
        }
        return this.executor;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public boolean isCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    class ProcessCall
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;

        public ProcessCall(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        public void run() {
            if (ThreadProcessor.this.shutdown.get()) {
                this.exchange.setException(new RejectedExecutionException());
            }
            this.callback.done(false);
        }
    }
}

