/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.camel.RuntimeCamelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectHelper {
    private static final transient Log LOG = LogFactory.getLog(ObjectHelper.class);

    private ObjectHelper() {
    }

    @Deprecated
    public static boolean equals(Object a, Object b) {
        return ObjectHelper.equal(a, b);
    }

    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return ObjectHelper.equalByteArray((byte[])a, (byte[])b);
        }
        return a != null && b != null && a.equals(b);
    }

    public static boolean equalByteArray(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null && a.length == b.length) {
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEqualToAny(Object object, Object ... values) {
        for (Object value : values) {
            if (!ObjectHelper.equal(object, value)) continue;
            return true;
        }
        return false;
    }

    public static int compare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equalsIgnoreCase(value.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static void notNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(name + " must be specified");
        }
    }

    public static void notNull(Object value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (value == null) {
            throw new IllegalArgumentException(name + " must be specified on: " + on);
        }
    }

    public static void notEmpty(String value, String name) {
        if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty");
        }
    }

    public static void notEmpty(String value, String name, Object on) {
        if (on == null) {
            ObjectHelper.notNull(value, name);
        } else if (ObjectHelper.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty on: " + on);
        }
    }

    public static String[] splitOnCharacter(String value, String needle, int count) {
        String[] rc = new String[count];
        rc[0] = value;
        for (int i = 1; i < count; ++i) {
            String v = rc[i - 1];
            int p = v.indexOf(needle);
            if (p < 0) {
                return rc;
            }
            rc[i - 1] = v.substring(0, p);
            rc[i] = v.substring(p + 1);
        }
        return rc;
    }

    public static String removeStartingCharacters(String text, char ch) {
        int idx = 0;
        while (text.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    public static String capitalize(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        String answer = text.substring(0, 1).toUpperCase();
        if (length > 1) {
            answer = answer + text.substring(1, length);
        }
        return answer;
    }

    public static boolean contains(Object collectionOrArray, Object value) {
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            return collection.contains(value);
        }
        if (collectionOrArray instanceof String && value instanceof String) {
            String str = (String)collectionOrArray;
            String subStr = (String)value;
            return str.contains(subStr);
        }
        Iterator iter = ObjectHelper.createIterator(collectionOrArray);
        while (iter.hasNext()) {
            if (!ObjectHelper.equal(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    public static Iterator createIterator(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.iterator();
        }
        if (value.getClass().isArray()) {
            List<Object> list = Arrays.asList((Object[])value);
            return list.iterator();
        }
        if (value instanceof NodeList) {
            final NodeList nodeList = (NodeList)value;
            return new Iterator<Node>(){
                int idx = -1;

                @Override
                public boolean hasNext() {
                    return ++this.idx < nodeList.getLength();
                }

                @Override
                public Node next() {
                    return nodeList.item(this.idx);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (value instanceof String) {
            final String s = (String)value;
            if (s.contains(",")) {
                Scanner scanner = new Scanner((String)value);
                scanner.useDelimiter(",");
                return scanner;
            }
            return new Iterator<String>(){
                int idx = -1;

                @Override
                public boolean hasNext() {
                    return ++this.idx == 0 && ObjectHelper.isNotEmpty(s);
                }

                @Override
                public String next() {
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.singletonList(value).iterator();
    }

    public static boolean matches(List list) {
        if (!list.isEmpty()) {
            Object value = list.get(0);
            if (value instanceof Boolean) {
                Boolean flag = (Boolean)value;
                return flag;
            }
            return true;
        }
        return false;
    }

    public static boolean isNotNullAndNonEmpty(String text) {
        return ObjectHelper.isNotEmpty(text);
    }

    public static boolean isNullOrBlank(String text) {
        return ObjectHelper.isEmpty(text);
    }

    public static boolean isEmpty(Object value) {
        return !ObjectHelper.isNotEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        return true;
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Caught security exception accessing system property: " + name + ". Reason: " + e), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static boolean getSystemProperty(String name, Boolean defaultValue) {
        String result = ObjectHelper.getSystemProperty(name, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static String name(Class type) {
        return type != null ? type.getName() : null;
    }

    public static String className(Object value) {
        return ObjectHelper.name(value != null ? value.getClass() : null);
    }

    public static String classCanonicalName(Object value) {
        if (value != null) {
            return value.getClass().getCanonicalName();
        }
        return null;
    }

    public static Class<?> loadClass(String name) {
        return ObjectHelper.loadClass(name, ObjectHelper.class.getClassLoader());
    }

    public static Class<?> loadClass(String name, ClassLoader loader) {
        if ("java.lang.byte[]".equals(name = ObjectHelper.normalizeClassName(name)) || "byte[]".equals(name)) {
            return byte[].class;
        }
        Class<?> clazz = ObjectHelper.doLoadClass(name, Thread.currentThread().getContextClassLoader());
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, loader);
        }
        if (clazz == null) {
            clazz = ObjectHelper.doLoadClass(name, ObjectHelper.class.getClassLoader());
        }
        if (clazz == null) {
            LOG.warn((Object)("Could not find class: " + name));
        }
        return clazz;
    }

    private static Class<?> doLoadClass(String name, ClassLoader loader) {
        ObjectHelper.notEmpty(name, "name");
        if (loader == null) {
            return null;
        }
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Can not load class: " + name + " using classloader: " + loader), (Throwable)e);
            }
            return null;
        }
    }

    public static InputStream loadResourceAsStream(String name) {
        InputStream in = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            in = contextClassLoader.getResourceAsStream(name);
        }
        if (in == null) {
            in = ObjectHelper.class.getClassLoader().getResourceAsStream(name);
        }
        return in;
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeCamelException(e.getCause());
        }
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return ObjectHelper.findMethodsWithAnnotation(type, annotationType, false);
    }

    public static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (!ObjectHelper.hasAnnotation(method, annotationType, checkMetaAnnotations)) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    public static boolean hasAnnotation(AnnotatedElement elem, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        if (elem.isAnnotationPresent(annotationType)) {
            return true;
        }
        if (checkMetaAnnotations) {
            for (Annotation a : elem.getAnnotations()) {
                for (Annotation meta : a.annotationType().getAnnotations()) {
                    if (!meta.annotationType().getName().equals(annotationType.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String asString(Object[] objects) {
        if (objects == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer("{");
        int counter = 0;
        for (Object object : objects) {
            if (counter++ > 0) {
                buffer.append(", ");
            }
            String text = object == null ? "null" : object.toString();
            buffer.append(text);
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static boolean isAssignableFrom(Class a, Class b) {
        a = ObjectHelper.convertPrimitiveTypeToWrapperType(a);
        b = ObjectHelper.convertPrimitiveTypeToWrapperType(b);
        return a.isAssignableFrom(b);
    }

    public static Class convertPrimitiveTypeToWrapperType(Class type) {
        Class rc = type;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                rc = Integer.class;
            } else if (type == Long.TYPE) {
                rc = Long.class;
            } else if (type == Double.TYPE) {
                rc = Double.class;
            } else if (type == Float.TYPE) {
                rc = Float.class;
            } else if (type == Short.TYPE) {
                rc = Short.class;
            } else if (type == Byte.TYPE) {
                rc = Byte.class;
            }
        }
        return rc;
    }

    public static String getDefaultCharacterSet() {
        return Charset.defaultCharset().name();
    }

    public static String getPropertyName(Method method) {
        String propertyName = method.getName();
        if (propertyName.startsWith("set") && method.getParameterTypes().length == 1) {
            propertyName = propertyName.substring(3, 4).toLowerCase() + propertyName.substring(4);
        }
        return propertyName;
    }

    public static boolean hasAnnotation(Annotation[] annotations, Class<?> type) {
        for (Annotation annotation : annotations) {
            if (!type.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public static void close(Closeable closeable, String name, Log log) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (log == null) break block3;
                    log.warn((Object)("Could not close: " + name + ". Reason: " + e), (Throwable)e);
                }
            }
        }
    }

    public static <T> T cast(Class<T> toType, Object value) {
        Class newType;
        if (toType == Boolean.TYPE) {
            return (T)ObjectHelper.cast(Boolean.class, value);
        }
        if (toType.isPrimitive() && (newType = ObjectHelper.convertPrimitiveTypeToWrapperType(toType)) != toType) {
            return ObjectHelper.cast(newType, value);
        }
        try {
            return toType.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Failed to convert: " + value + " to type: " + toType.getName() + " due to: " + e, e);
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeCamelException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static <T> T newInstance(Class<?> actualType, Class<T> expectedType) {
        try {
            Object value = actualType.newInstance();
            return ObjectHelper.cast(expectedType, value);
        }
        catch (InstantiationException e) {
            throw new RuntimeCamelException();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException(e);
        }
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int size = name.length();
        if (size < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i = 1; i < size; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object type(Object bean) {
        return bean != null ? bean.getClass() : null;
    }

    public static boolean evaluateValuePredicate(Object value) {
        if (value instanceof Boolean) {
            Boolean aBoolean = (Boolean)value;
            return aBoolean;
        }
        if (value instanceof String) {
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
        }
        return value != null;
    }

    public static RuntimeCamelException wrapRuntimeCamelException(Throwable e) {
        if (e instanceof RuntimeCamelException) {
            return (RuntimeCamelException)e;
        }
        return new RuntimeCamelException(e);
    }

    public static String normalizeClassName(String name) {
        StringBuffer sb = new StringBuffer(name.length());
        for (char ch : name.toCharArray()) {
            if (ch != '.' && ch != '[' && ch != ']' && !Character.isJavaIdentifierPart(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static String before(String text, String before) {
        if (!text.contains(before)) {
            return null;
        }
        return text.substring(0, text.indexOf(before));
    }

    public static String between(String text, String after, String before) {
        if ((text = ObjectHelper.after(text, after)) == null) {
            return null;
        }
        return ObjectHelper.before(text, before);
    }
}

