/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.RoutesType;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelFileGenerator {
    private static final String DEFAULT_ROOT_ELEMENT_NAME = "routes";
    private final JAXBContext jaxbContext;
    private Binder<Node> binder;

    public ModelFileGenerator(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public void marshalRoutesUsingJaxb(String fileName, List<RouteType> routeTypes) throws IOException {
        OutputStream outputStream = this.outputStream(fileName);
        try {
            XmlConverter converter = this.converter();
            Document doc = converter.createDocument();
            Element root = doc.createElement(this.rootElementName());
            root.setAttribute("xmlns", "http://activemq.apache.org/camel/schema/spring");
            doc.appendChild(root);
            for (RouteType routeType : routeTypes) {
                this.addJaxbElementToNode(root, routeType);
            }
            StreamResult result = new StreamResult(new OutputStreamWriter(outputStream, XmlConverter.defaultCharset));
            this.copyToResult(converter, doc, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeTransformException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeTransformException(e);
        }
        finally {
            outputStream.close();
        }
    }

    private XmlConverter converter() {
        XmlConverter converter = new XmlConverter();
        TransformerFactory transformerFactory = converter.getTransformerFactory();
        transformerFactory.setAttribute("indent-number", new Integer(2));
        return converter;
    }

    private void copyToResult(XmlConverter converter, Document doc, Result result) throws TransformerException {
        Properties outputProperties = converter.defaultOutputProperties();
        outputProperties.put("omit-xml-declaration", "no");
        outputProperties.put("indent", "yes");
        converter.toResult(converter.toSource(doc), result, outputProperties);
    }

    private void addJaxbElementToNode(Node node, Object jaxbElement) {
        try {
            if (this.binder == null) {
                this.binder = this.jaxbContext.createBinder();
            }
            this.binder.marshal(jaxbElement, (Object)node);
        }
        catch (JAXBException e) {
            throw new RuntimeCamelException(e);
        }
    }

    private String rootElementName() {
        String elementName;
        XmlRootElement annotation = RoutesType.class.getAnnotation(XmlRootElement.class);
        if (annotation != null && ObjectHelper.isNotNullAndNonEmpty(elementName = annotation.name())) {
            return elementName;
        }
        return DEFAULT_ROOT_ELEMENT_NAME;
    }

    private OutputStream outputStream(String fileName) throws FileNotFoundException {
        File parentFile;
        File file = new File(fileName);
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            parentFile.mkdirs();
        }
        return new FileOutputStream(file);
    }
}

