/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jbi.management.DeploymentException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.servicemix.camel.CamelControlBus;
import org.apache.servicemix.camel.CamelJbiComponent;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.camel.JbiComponent;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.AbstractXBeanDeployer;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.server.spring.loader.PureSpringLoader;
import org.apache.xbean.server.spring.loader.SpringLoader;
import org.apache.xbean.spring.context.FileSystemXmlApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class CamelSpringDeployer
extends AbstractXBeanDeployer {
    private final CamelJbiComponent component;
    private PureSpringLoader springLoader = new PureSpringLoader(){

        protected AbstractXmlApplicationContext createXmlApplicationContext(String configLocation) {
            ApplicationContext parentAppContext = CamelSpringDeployer.this.createParentApplicationContext(this.getXmlPreprocessors());
            return new FileSystemXmlApplicationContext(new String[]{configLocation}, false, parentAppContext, this.getXmlPreprocessors());
        }
    };
    private List<CamelProviderEndpoint> activatedEndpoints = new ArrayList<CamelProviderEndpoint>();
    private String serviceUnitName;

    public CamelSpringDeployer(CamelJbiComponent component) {
        super((ServiceMixComponent)component);
        this.component = component;
    }

    protected String getXBeanFile() {
        return "camel-context";
    }

    public void undeploy(ServiceUnit su) throws DeploymentException {
        this.component.removeJbiComponent(su.getName());
        super.undeploy(su);
    }

    public ServiceUnit deploy(String suName, String serviceUnitRootPath) throws DeploymentException {
        this.component.deployer = this;
        this.serviceUnitName = suName;
        ServiceUnit serviceUnit = super.deploy(suName, serviceUnitRootPath);
        return serviceUnit;
    }

    public void addService(CamelProviderEndpoint endpoint) {
        this.activatedEndpoints.add(endpoint);
    }

    protected List getServices(Kernel kernel) {
        try {
            ArrayList<CamelProviderEndpoint> services = new ArrayList<CamelProviderEndpoint>(this.activatedEndpoints);
            this.activatedEndpoints.clear();
            AbstractXmlApplicationContext applicationContext = this.springLoader.getApplicationContext();
            SpringCamelContext camelContext = SpringCamelContext.springCamelContext((ApplicationContext)applicationContext);
            JbiComponent jbiComponent = (JbiComponent)camelContext.getComponent("jbi", JbiComponent.class);
            Collection endpoints = camelContext.getSingletonEndpoints();
            if (jbiComponent != null) {
                Endpoint endpoint2;
                jbiComponent.setSuName(this.serviceUnitName);
                for (Endpoint endpoint2 : endpoints) {
                    if (!this.component.isEndpointExposedOnNmr(endpoint2)) continue;
                    services.add(jbiComponent.createJbiEndpointFromCamel(endpoint2));
                }
                BeanComponent beanComponent = (BeanComponent)camelContext.getComponent("bean", BeanComponent.class);
                endpoint2 = beanComponent.createEndpoint((Object)new CamelControlBus((CamelContext)camelContext), "camel:" + this.serviceUnitName + "-controlBus");
                services.add(jbiComponent.createJbiEndpointFromCamel(endpoint2));
            }
            return services;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SpringLoader createSpringLoader() {
        return this.springLoader;
    }

    protected ApplicationContext createParentApplicationContext(List xmlProcessors) {
        GenericApplicationContext answer = new GenericApplicationContext();
        answer.getBeanFactory().registerSingleton("servicemix-camel", (Object)this.component);
        answer.getBeanFactory().registerSingleton("jbi", (Object)new JbiComponent(this.component));
        answer.setClassLoader(Thread.currentThread().getContextClassLoader());
        answer.start();
        answer.refresh();
        return answer;
    }
}

