/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.camel.JbiExchange;
import org.apache.servicemix.camel.util.BasicSerializationHeaderFilterStrategy;
import org.apache.servicemix.camel.util.HeaderFilterStrategies;
import org.apache.servicemix.camel.util.StrictSerializationHeaderFilterStrategy;
import org.apache.servicemix.jbi.FaultException;

public class JbiBinding {
    public static final String MESSAGE_EXCHANGE = "JbiMessageExchange";
    public static final String OPERATION = "JbiOperation";
    public static final String SECURITY_SUBJECT = "JbiSecuritySubject";
    @Deprecated
    public static final String OPERATION_STRING = "jbi.operation";
    private static final Log LOG = LogFactory.getLog(JbiBinding.class);
    private final CamelContext context;
    private HeaderFilterStrategies strategies = new HeaderFilterStrategies();
    private boolean convertExceptions;

    public JbiBinding(CamelContext context) {
        this(context, false);
    }

    public JbiBinding(CamelContext context, boolean strictSerialization) {
        this.context = context;
        if (strictSerialization) {
            this.strategies.add(new StrictSerializationHeaderFilterStrategy());
        } else {
            this.strategies.add(new BasicSerializationHeaderFilterStrategy());
        }
    }

    public void addHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.strategies.add(strategy);
    }

    public void setConvertExceptions(boolean convertExceptions) {
        this.convertExceptions = convertExceptions;
    }

    public MessageExchange makeJbiMessageExchange(Exchange camelExchange, MessageExchangeFactory exchangeFactory, String defaultMep) throws MessagingException, URISyntaxException {
        MessageExchange jbiExchange = this.createJbiMessageExchange(camelExchange, exchangeFactory, defaultMep);
        NormalizedMessage normalizedMessage = jbiExchange.getMessage("in");
        if (normalizedMessage == null) {
            normalizedMessage = jbiExchange.createMessage();
            jbiExchange.setMessage(normalizedMessage, "in");
        }
        this.copyFromCamelToJbi(camelExchange.getIn(), normalizedMessage);
        return jbiExchange;
    }

    protected MessageExchange createJbiMessageExchange(Exchange camelExchange, MessageExchangeFactory exchangeFactory, String defaultMep) throws MessagingException, URISyntaxException {
        ExchangePattern mep = ExchangePattern.fromWsdlUri((String)defaultMep);
        if (mep == null) {
            mep = camelExchange.getPattern();
        }
        Object answer = null;
        if (mep != null) {
            answer = mep == ExchangePattern.InOnly ? exchangeFactory.createInOnlyExchange() : (mep == ExchangePattern.InOptionalOut ? exchangeFactory.createInOptionalOutExchange() : (mep == ExchangePattern.InOut ? exchangeFactory.createInOutExchange() : (mep == ExchangePattern.RobustInOnly ? exchangeFactory.createRobustInOnlyExchange() : exchangeFactory.createExchange(new URI(mep.toString())))));
        }
        if (answer == null) {
            Message out = camelExchange.getOut(false);
            answer = out == null || out.getBody() == null ? exchangeFactory.createInOnlyExchange() : exchangeFactory.createInOutExchange();
        }
        if (JbiBinding.getOperation(camelExchange) != null) {
            answer.setOperation(JbiBinding.getOperation(camelExchange));
        }
        if (answer.getOperation() == null && camelExchange.getProperties().containsKey(OPERATION_STRING)) {
            answer.setOperation(QName.valueOf((String)camelExchange.getProperty(OPERATION_STRING, String.class)));
        }
        return answer;
    }

    public Exchange createExchange(MessageExchange exchange) {
        JbiExchange result = new JbiExchange(this.context, this);
        result.setProperty(MESSAGE_EXCHANGE, exchange);
        result.setPattern(this.getExchangePattern(exchange));
        if (exchange.getOperation() != null) {
            result.setProperty(OPERATION, exchange.getOperation());
            result.setProperty(OPERATION_STRING, exchange.getOperation().toString());
        }
        if (exchange.getMessage("in") != null) {
            this.copyJbiToCamel(exchange.getMessage("in"), result.getIn());
        }
        return result;
    }

    private ExchangePattern getExchangePattern(MessageExchange exchange) {
        if (exchange instanceof InOut) {
            return ExchangePattern.InOut;
        }
        if (exchange instanceof InOptionalOut) {
            return ExchangePattern.InOptionalOut;
        }
        if (exchange instanceof RobustInOnly) {
            return ExchangePattern.RobustInOnly;
        }
        return ExchangePattern.InOnly;
    }

    private void copyJbiToCamel(NormalizedMessage from, Message to) {
        to.setBody((Object)from.getContent());
        if (from.getSecuritySubject() != null) {
            to.setHeader(SECURITY_SUBJECT, (Object)from.getSecuritySubject());
        }
        for (Object key : from.getPropertyNames()) {
            to.setHeader(key.toString(), from.getProperty(key.toString()));
        }
        for (Object id : from.getAttachmentNames()) {
            to.addAttachment(id.toString(), from.getAttachment(id.toString()));
        }
    }

    public void copyFromCamelToJbi(Message message, NormalizedMessage normalizedMessage) throws MessagingException {
        try {
            normalizedMessage.setContent((Source)message.getBody(Source.class));
        }
        catch (NoTypeConversionAvailableException e) {
            LOG.warn((Object)("Unable to convert message body of type " + message.getBody().getClass() + " into an XML Source"));
        }
        if (JbiBinding.getSecuritySubject(message) != null) {
            normalizedMessage.setSecuritySubject(JbiBinding.getSecuritySubject(message));
        }
        for (String key : message.getHeaders().keySet()) {
            Object value;
            if (this.strategies.applyFilterToCamelHeaders(key, value = message.getHeader(key))) continue;
            normalizedMessage.setProperty(key, value);
        }
        for (String id : message.getAttachmentNames()) {
            normalizedMessage.addAttachment(id, message.getAttachment(id));
        }
    }

    public void copyFromCamelToJbi(Exchange exchange, MessageExchange messageExchange) throws MessagingException {
        NormalizedMessage in = messageExchange.getMessage("in");
        for (String key : exchange.getIn().getHeaders().keySet()) {
            in.setProperty(key, exchange.getIn().getHeader(key));
        }
        if (this.isOutCapable(messageExchange)) {
            NormalizedMessage out;
            if (exchange.getOut(false) == null) {
                out = messageExchange.createMessage();
                this.copyFromCamelToJbi(exchange.getIn(), out);
                messageExchange.setMessage(out, "out");
            } else {
                out = messageExchange.createMessage();
                this.copyFromCamelToJbi(exchange.getOut(), out);
                messageExchange.setMessage(out, "out");
            }
        }
    }

    public Exception extractException(Exchange exchange) {
        Throwable e = exchange.getException();
        if (!(e instanceof Exception) || this.convertExceptions) {
            e = (Throwable)this.context.getTypeConverter().convertTo(FaultException.class, (Object)exchange);
        }
        return (Exception)e;
    }

    private boolean isOutCapable(MessageExchange exchange) {
        return exchange instanceof InOut || exchange instanceof InOptionalOut;
    }

    public static MessageExchange getMessageExchange(Exchange exchange) {
        return (MessageExchange)exchange.getProperty(MESSAGE_EXCHANGE, MessageExchange.class);
    }

    public static QName getOperation(Exchange exchange) {
        return (QName)exchange.getProperty(OPERATION, QName.class);
    }

    public static Subject getSecuritySubject(Message message) {
        if (message.getHeader(SECURITY_SUBJECT) != null) {
            return (Subject)message.getHeader(SECURITY_SUBJECT, Subject.class);
        }
        return null;
    }
}

