/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.camel.CamelConsumerEndpoint;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiComponent;
import org.apache.servicemix.camel.JbiException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiEndpoint
extends DefaultEndpoint<Exchange> {
    private static final String STRICT_SERIALIZATION = "strict";
    private String destinationUri;
    private String mep;
    private String operation;
    private JbiProducer producer;
    private boolean convertExceptions;
    private boolean strictSerialization;
    private HeaderFilterStrategy headerFilterStrategy;
    private final JbiComponent jbiComponent;
    private final JbiBinding binding;

    public JbiEndpoint(JbiComponent jbiComponent, String uri) {
        super(uri, (Component)jbiComponent);
        this.jbiComponent = jbiComponent;
        this.parseUri(uri);
        this.binding = this.createBinding();
    }

    public final JbiBinding createBinding() {
        JbiBinding result = new JbiBinding(this.getCamelContext(), this.strictSerialization);
        result.setConvertExceptions(this.convertExceptions);
        result.addHeaderFilterStrategy(this.headerFilterStrategy);
        return result;
    }

    public synchronized Producer<Exchange> createProducer() throws Exception {
        if (this.producer == null) {
            this.producer = new JbiProducer((Endpoint<Exchange>)this);
        }
        return this.producer;
    }

    private void parseUri(String uri) {
        this.destinationUri = uri;
        try {
            int idx = this.destinationUri.indexOf(63);
            if (idx > 0) {
                String serialization;
                String convert;
                String oper;
                Map params = URISupport.parseQuery((String)this.destinationUri.substring(idx + 1));
                this.mep = (String)params.get("mep");
                if (this.mep != null && !this.mep.startsWith("http://www.w3.org/ns/wsdl/")) {
                    this.mep = "http://www.w3.org/ns/wsdl/" + this.mep;
                }
                if (StringUtils.hasLength((String)(oper = (String)params.get("operation")))) {
                    this.operation = oper;
                }
                this.destinationUri = this.destinationUri.substring(0, idx);
                String filter = (String)params.get("headerFilterStrategy");
                if (StringUtils.hasLength((String)filter)) {
                    Object object;
                    Registry registry = this.jbiComponent.getCamelContext().getRegistry();
                    if (filter.indexOf(35) != -1) {
                        filter = filter.substring(1);
                    }
                    if ((object = registry.lookup(filter)) instanceof HeaderFilterStrategy) {
                        this.headerFilterStrategy = (HeaderFilterStrategy)object;
                    }
                    params.remove("headerFilterStrategy");
                }
                if (StringUtils.hasLength((String)(convert = (String)params.get("convertExceptions")))) {
                    this.convertExceptions = Boolean.valueOf(convert);
                    params.remove("convertExceptions");
                }
                if (StringUtils.hasLength((String)(serialization = (String)params.get("serialization")))) {
                    this.strictSerialization = STRICT_SERIALIZATION.equalsIgnoreCase(serialization);
                    params.remove("serialization");
                }
                String endpointUri = this.destinationUri + URISupport.createQueryString((Map)params);
                this.setEndpointUri(endpointUri);
            }
        }
        catch (URISyntaxException e) {
            throw new JbiException(e);
        }
    }

    public void setMep(String str) {
        this.mep = str;
    }

    public void setOperation(String str) {
        this.operation = str;
    }

    public void setDestionationUri(String str) {
        this.destinationUri = str;
    }

    public String getMep() {
        return this.mep;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    public Consumer<Exchange> createConsumer(final Processor processor) throws Exception {
        return new DefaultConsumer<Exchange>((Endpoint)this, processor){
            CamelProviderEndpoint jbiEndpoint;

            protected void doStart() throws Exception {
                super.doStart();
                this.jbiEndpoint = JbiEndpoint.this.jbiComponent.createJbiEndpointFromCamel((Endpoint)JbiEndpoint.this, processor);
                JbiEndpoint.this.jbiComponent.getCamelJbiComponent().activateJbiEndpoint(this.jbiEndpoint);
            }

            protected void doStop() throws Exception {
                if (this.jbiEndpoint != null) {
                    JbiEndpoint.this.jbiComponent.getCamelJbiComponent().deactivateJbiEndpoint(this.jbiEndpoint);
                }
                super.doStop();
            }
        };
    }

    public boolean isSingleton() {
        return true;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public void setConvertExceptions(boolean convertExceptions) {
        this.convertExceptions = convertExceptions;
    }

    public boolean isConvertExceptions() {
        return this.convertExceptions;
    }

    public void setStrictSerialization(boolean strictSerialization) {
        this.strictSerialization = strictSerialization;
    }

    public boolean isStrictSerialization() {
        return this.strictSerialization;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JbiProducer
    extends DefaultProducer<Exchange>
    implements AsyncProcessor {
        private final Log log;
        private CamelConsumerEndpoint consumer;

        public JbiProducer(Endpoint<Exchange> exchangeEndpoint) {
            super(exchangeEndpoint);
            this.log = LogFactory.getLog(JbiProducer.class);
        }

        public void start() throws Exception {
            this.consumer = new CamelConsumerEndpoint(JbiEndpoint.this.binding, JbiEndpoint.this);
            JbiEndpoint.this.jbiComponent.getCamelJbiComponent().addEndpoint((org.apache.servicemix.common.Endpoint)this.consumer);
            super.start();
        }

        public void stop() throws Exception {
            if (this.isStopped()) {
                this.log.debug((Object)("Camel producer for " + super.getEndpoint() + " has already been stopped"));
            } else {
                this.log.debug((Object)("Stopping Camel producer for " + super.getEndpoint()));
                JbiEndpoint.this.jbiComponent.getCamelJbiComponent().removeEndpoint((org.apache.servicemix.common.Endpoint)this.consumer);
                super.stop();
            }
        }

        public void process(Exchange exchange) throws Exception {
            this.consumer.process(exchange);
        }

        public boolean process(Exchange exchange, AsyncCallback asyncCallback) {
            return this.consumer.process(exchange, asyncCallback);
        }

        protected CamelConsumerEndpoint getCamelConsumerEndpoint() {
            return this.consumer;
        }
    }
}

