/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicemix.camel;

import java.util.Collection;

import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;

/**
 * A simple control bus for accessing Camel features over the JBI NMR
 *
 * @version $Revision: 563665 $
 */
public class CamelControlBus {
    private CamelContext camelContext;

    public CamelControlBus(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Collection<Endpoint> getEndpoints(@Body String filter) {
        return camelContext.getSingletonEndpoints();
    }
}