/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.servicemix.camel.CamelConsumerEndpoint;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.camel.CamelSpringDeployer;
import org.apache.servicemix.camel.JbiComponent;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.jbi.util.IntrospectionSupport;
import org.apache.servicemix.jbi.util.URISupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelJbiComponent
extends DefaultComponent {
    protected CamelSpringDeployer deployer;
    private List<JbiComponent> jbiComponents = new ArrayList<JbiComponent>();

    public BaseServiceUnitManager createServiceUnitManager() {
        Deployer[] deployers = new Deployer[]{new CamelSpringDeployer(this)};
        return new BaseServiceUnitManager((ServiceMixComponent)this, deployers);
    }

    protected List<CamelProviderEndpoint> getConfiguredEndpoints() {
        return new ArrayList<CamelProviderEndpoint>();
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{CamelProviderEndpoint.class, CamelConsumerEndpoint.class};
    }

    protected String[] getEPRProtocols() {
        return new String[]{"camel"};
    }

    protected org.apache.servicemix.common.Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        CamelProviderEndpoint endpoint = null;
        JbiComponent jbiComponent = null;
        String uriString = "";
        String endpointName = ep.getEndpointName();
        String[] names = endpointName.split(":");
        if (names.length <= 2) {
            throw new IllegalStateException("Can't find the su name from the endpoint name");
        }
        jbiComponent = this.getJbiComponent(names[1]);
        if (jbiComponent != null) {
            int index = 0;
            for (String name : names) {
                if (index == 0) {
                    uriString = name;
                }
                if (index > 1) {
                    uriString = uriString + ":" + name;
                }
                ++index;
            }
        } else {
            throw new IllegalStateException("Can't find the JbiComponent");
        }
        endpoint = this.createEndpoint(uriString, jbiComponent);
        endpoint.activate();
        return endpoint;
    }

    public CamelProviderEndpoint createEndpoint(String uriString, JbiComponent jbiComponent) throws URISyntaxException {
        URI uri = new URI(uriString);
        Map map = URISupport.parseQuery((String)uri.getQuery());
        String camelUri = uri.getSchemeSpecificPart();
        Endpoint camelEndpoint = jbiComponent.getCamelContext().getEndpoint(camelUri);
        Processor processor = jbiComponent.createCamelProcessor(camelEndpoint);
        CamelProviderEndpoint endpoint = new CamelProviderEndpoint(this.getServiceUnit(), camelEndpoint, jbiComponent.createBinding(camelEndpoint), processor);
        IntrospectionSupport.setProperties((Object)((Object)endpoint), (Map)map);
        return endpoint;
    }

    public synchronized void addJbiComponent(JbiComponent jbiComponent) {
        this.jbiComponents.add(jbiComponent);
    }

    public synchronized void removeJbiComponent(String suName) {
        JbiComponent component = this.getJbiComponent(suName);
        if (component != null) {
            this.jbiComponents.remove(component);
        }
    }

    public synchronized JbiComponent getJbiComponent(String suName) {
        JbiComponent result = null;
        for (JbiComponent component : this.jbiComponents) {
            if (!suName.equals(component.getSuName())) continue;
            result = component;
            break;
        }
        return result;
    }

    public void activateJbiEndpoint(CamelProviderEndpoint jbiEndpoint) throws Exception {
        if (this.deployer != null) {
            this.deployer.addService(jbiEndpoint);
        } else {
            this.addEndpoint((org.apache.servicemix.common.Endpoint)jbiEndpoint);
        }
    }

    public void deactivateJbiEndpoint(CamelProviderEndpoint jbiEndpoint) throws Exception {
    }

    public boolean isEndpointExposedOnNmr(Endpoint endpoint) {
        return false;
    }
}

