/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jbi.FaultException;

public class CamelProviderEndpoint
extends ProviderEndpoint {
    public static final QName SERVICE_NAME = new QName("http://activemq.apache.org/camel/schema/jbi", "provider");
    private JbiBinding binding;
    private Processor camelProcessor;

    public CamelProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint, JbiBinding binding, Processor camelProcessor) {
        super(serviceUnit, service, endpoint);
        this.camelProcessor = camelProcessor;
        this.binding = binding;
    }

    public CamelProviderEndpoint(ServiceUnit serviceUnit, Endpoint camelEndpoint, JbiBinding binding, Processor camelProcessor) {
        this(serviceUnit, SERVICE_NAME, camelEndpoint.getEndpointUri(), binding, camelProcessor);
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                return;
            }
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                return;
            }
        } else {
            throw new IllegalStateException("Unsupported role: " + exchange.getRole());
        }
        this.handleActiveProviderExchange(exchange);
    }

    protected void handleActiveProviderExchange(MessageExchange exchange) throws Exception {
        if (exchange.getFault() != null) {
            this.done(exchange);
        } else if (exchange.getMessage("in") != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received exchange: " + exchange));
            }
            Exchange camelExchange = this.binding.createExchange(exchange);
            this.camelProcessor.process(camelExchange);
            if (camelExchange.isFailed()) {
                this.handleFailure(exchange, camelExchange);
            } else {
                this.handleSuccess(exchange, camelExchange);
            }
        } else {
            throw new IllegalStateException("Provider exchange is ACTIVE, but no in or fault is provided");
        }
    }

    private void handleSuccess(MessageExchange exchange, Exchange camelExchange) throws MessagingException {
        this.binding.copyFromCamelToJbi(camelExchange, exchange);
        if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
            this.done(exchange);
        } else {
            this.doSend(exchange);
        }
    }

    private void handleFailure(MessageExchange exchange, Exchange camelExchange) throws MessagingException {
        if (camelExchange.getFault(false) == null || camelExchange.getFault(false).getBody() == null) {
            this.fail(exchange, this.binding.extractException(camelExchange));
        } else {
            Fault fault = exchange.createFault();
            this.binding.copyFromCamelToJbi(camelExchange.getFault(), (NormalizedMessage)fault);
            if (this.isFaultCapable(exchange)) {
                exchange.setFault(fault);
                this.doSend(exchange);
            } else {
                this.fail(exchange, (Exception)new FaultException("Fault occured for " + exchange.getPattern() + " exchange", exchange, fault));
            }
        }
    }

    private boolean isFaultCapable(MessageExchange exchange) {
        return !(exchange instanceof InOnly);
    }

    private void doSend(MessageExchange exchange) throws MessagingException {
        boolean txSync;
        boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
        if (txSync && ExchangeStatus.ACTIVE.equals(exchange.getStatus())) {
            this.sendSync(exchange);
        } else {
            this.send(exchange);
        }
    }
}

