/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoSuchPropertyException
extends CamelExchangeException {
    private static final long serialVersionUID = -8721487431101572630L;
    private final String propertyName;
    private final Class<?> type;

    public NoSuchPropertyException(Exchange exchange, String propertyName, Class<?> type) {
        super("No '" + propertyName + "' property available of type: " + type.getName() + NoSuchPropertyException.reason(exchange, propertyName), exchange);
        this.propertyName = propertyName;
        this.type = type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected static String reason(Exchange exchange, String propertyName) {
        Object value = exchange.getProperty(propertyName);
        return NoSuchPropertyException.valueDescription(value);
    }

    static String valueDescription(Object value) {
        if (value == null) {
            return "";
        }
        return " but has value: " + value + " of type: " + value.getClass().getName();
    }
}

