/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.builder.xml.DefaultNamespaceContext;
import org.apache.camel.builder.xml.InvalidXPathExpression;
import org.apache.camel.builder.xml.MessageVariableResolver;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathBuilder<E extends Exchange>
implements Expression<E>,
Predicate<E>,
NamespaceAware {
    private final String text;
    private XPathFactory xpathFactory;
    private Class documentType = Document.class;
    private Class resultType;
    private QName resultQName = XPathConstants.NODESET;
    private String objectModelUri;
    private DefaultNamespaceContext namespaceContext;
    private XPathFunctionResolver functionResolver;
    private XPathExpression expression;
    private MessageVariableResolver variableResolver = new MessageVariableResolver();
    private E exchange;
    private XPathFunction bodyFunction;
    private XPathFunction headerFunction;
    private XPathFunction outBodyFunction;
    private XPathFunction outHeaderFunction;

    public XPathBuilder(String text) {
        this.text = text;
    }

    public static XPathBuilder xpath(String text) {
        return new XPathBuilder(text);
    }

    public static XPathBuilder xpath(String text, Class resultType) {
        XPathBuilder builder = new XPathBuilder(text);
        builder.setResultType(resultType);
        return builder;
    }

    public String toString() {
        return "XPath: " + this.text;
    }

    @Override
    public boolean matches(E exchange) {
        Object booleanResult = this.evaluateAs(exchange, XPathConstants.BOOLEAN);
        return ObjectConverter.toBoolean(booleanResult);
    }

    @Override
    public void assertMatches(String text, E exchange) throws AssertionError {
        Object booleanResult = this.evaluateAs(exchange, XPathConstants.BOOLEAN);
        if (!ObjectConverter.toBoolean(booleanResult).booleanValue()) {
            throw new AssertionError((Object)(this + " failed on " + exchange + " as returned <" + booleanResult + ">"));
        }
    }

    @Override
    public Object evaluate(E exchange) {
        Object answer = this.evaluateAs(exchange, this.resultQName);
        if (this.resultType != null) {
            return ExchangeHelper.convertToType(exchange, this.resultType, answer);
        }
        return answer;
    }

    public XPathBuilder<E> booleanResult() {
        this.resultQName = XPathConstants.BOOLEAN;
        return this;
    }

    public XPathBuilder<E> nodeResult() {
        this.resultQName = XPathConstants.NODE;
        return this;
    }

    public XPathBuilder<E> nodeSetResult() {
        this.resultQName = XPathConstants.NODESET;
        return this;
    }

    public XPathBuilder<E> numberResult() {
        this.resultQName = XPathConstants.NUMBER;
        return this;
    }

    public XPathBuilder<E> stringResult() {
        this.resultQName = XPathConstants.STRING;
        return this;
    }

    public XPathBuilder<E> resultType(Class resultType) {
        this.setResultType(resultType);
        return this;
    }

    public XPathBuilder<E> objectModel(String uri) {
        this.objectModelUri = uri;
        return this;
    }

    public XPathBuilder<E> functionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
        return this;
    }

    public XPathBuilder<E> namespace(String prefix, String uri) {
        this.getNamespaceContext().add(prefix, uri);
        return this;
    }

    public XPathBuilder<E> namespaces(Namespaces namespaces) {
        namespaces.configure(this);
        return this;
    }

    public XPathBuilder<E> variable(String name, Object value) {
        this.variableResolver.addVariable(name, value);
        return this;
    }

    public XPathFactory getXPathFactory() throws XPathFactoryConfigurationException {
        if (this.xpathFactory == null) {
            if (this.objectModelUri != null) {
                this.xpathFactory = XPathFactory.newInstance(this.objectModelUri);
            }
            this.xpathFactory = XPathFactory.newInstance();
        }
        return this.xpathFactory;
    }

    public void setXPathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public Class getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Class documentType) {
        this.documentType = documentType;
    }

    public String getText() {
        return this.text;
    }

    public QName getResultQName() {
        return this.resultQName;
    }

    public void setResultQName(QName resultQName) {
        this.resultQName = resultQName;
    }

    public DefaultNamespaceContext getNamespaceContext() {
        if (this.namespaceContext == null) {
            try {
                DefaultNamespaceContext defaultNamespaceContext = new DefaultNamespaceContext(this.getXPathFactory());
                this.populateDefaultNamespaces(defaultNamespaceContext);
                this.namespaceContext = defaultNamespaceContext;
            }
            catch (XPathFactoryConfigurationException e) {
                throw new RuntimeExpressionException(e);
            }
        }
        return this.namespaceContext;
    }

    public void setNamespaceContext(DefaultNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public XPathFunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public void setFunctionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    public XPathExpression getExpression() throws XPathFactoryConfigurationException, XPathExpressionException {
        if (this.expression == null) {
            this.expression = this.createXPathExpression();
        }
        return this.expression;
    }

    @Override
    public void setNamespaces(Map<String, String> namespaces) {
        this.getNamespaceContext().setNamespaces(namespaces);
    }

    public XPathFunction getBodyFunction() {
        if (this.bodyFunction == null) {
            this.bodyFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    if (XPathBuilder.this.exchange == null) {
                        return null;
                    }
                    return XPathBuilder.this.exchange.getIn().getBody();
                }
            };
        }
        return this.bodyFunction;
    }

    public void setBodyFunction(XPathFunction bodyFunction) {
        this.bodyFunction = bodyFunction;
    }

    public XPathFunction getHeaderFunction() {
        if (this.headerFunction == null) {
            this.headerFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    Object value;
                    if (XPathBuilder.this.exchange != null && !list.isEmpty() && (value = list.get(0)) != null) {
                        return XPathBuilder.this.exchange.getIn().getHeader(value.toString());
                    }
                    return null;
                }
            };
        }
        return this.headerFunction;
    }

    public void setHeaderFunction(XPathFunction headerFunction) {
        this.headerFunction = headerFunction;
    }

    public XPathFunction getOutBodyFunction() {
        if (this.outBodyFunction == null) {
            this.outBodyFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    Message out;
                    if (XPathBuilder.this.exchange != null && (out = XPathBuilder.this.exchange.getOut(false)) != null) {
                        return out.getBody();
                    }
                    return null;
                }
            };
        }
        return this.outBodyFunction;
    }

    public void setOutBodyFunction(XPathFunction outBodyFunction) {
        this.outBodyFunction = outBodyFunction;
    }

    public XPathFunction getOutHeaderFunction() {
        if (this.outHeaderFunction == null) {
            this.outHeaderFunction = new XPathFunction(){

                public Object evaluate(List list) throws XPathFunctionException {
                    Object value;
                    if (XPathBuilder.this.exchange != null && !list.isEmpty() && (value = list.get(0)) != null) {
                        return XPathBuilder.this.exchange.getOut().getHeader(value.toString());
                    }
                    return null;
                }
            };
        }
        return this.outHeaderFunction;
    }

    public void setOutHeaderFunction(XPathFunction outHeaderFunction) {
        this.outHeaderFunction = outHeaderFunction;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
        if (Number.class.isAssignableFrom(resultType)) {
            this.numberResult();
        } else if (String.class.isAssignableFrom(resultType)) {
            this.stringResult();
        } else if (Boolean.class.isAssignableFrom(resultType)) {
            this.booleanResult();
        } else if (Node.class.isAssignableFrom(resultType)) {
            this.nodeResult();
        } else if (NodeList.class.isAssignableFrom(resultType)) {
            this.nodeSetResult();
        }
    }

    protected synchronized Object evaluateAs(E exchange, QName resultQName) {
        this.exchange = exchange;
        this.variableResolver.setExchange((Exchange)exchange);
        try {
            Object document = this.getDocument(exchange);
            if (resultQName != null) {
                if (document instanceof InputSource) {
                    InputSource inputSource = (InputSource)document;
                    return this.getExpression().evaluate(inputSource, resultQName);
                }
                if (document instanceof DOMSource) {
                    DOMSource source = (DOMSource)document;
                    return this.getExpression().evaluate(source.getNode(), resultQName);
                }
                return this.getExpression().evaluate(document, resultQName);
            }
            if (document instanceof InputSource) {
                InputSource inputSource = (InputSource)document;
                return this.getExpression().evaluate(inputSource);
            }
            if (document instanceof DOMSource) {
                DOMSource source = (DOMSource)document;
                return this.getExpression().evaluate(source.getNode());
            }
            return this.getExpression().evaluate(document);
        }
        catch (XPathExpressionException e) {
            throw new InvalidXPathExpression(this.getText(), e);
        }
        catch (XPathFactoryConfigurationException e) {
            throw new InvalidXPathExpression(this.getText(), e);
        }
    }

    protected XPathExpression createXPathExpression() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.getXPathFactory().newXPath();
        this.xpathFactory = null;
        xPath.setNamespaceContext(this.getNamespaceContext());
        xPath.setXPathVariableResolver(this.variableResolver);
        XPathFunctionResolver parentResolver = this.getFunctionResolver();
        if (parentResolver == null) {
            parentResolver = xPath.getXPathFunctionResolver();
        }
        xPath.setXPathFunctionResolver(this.createDefaultFunctionResolver(parentResolver));
        return xPath.compile(this.text);
    }

    protected void populateDefaultNamespaces(DefaultNamespaceContext context) {
        this.setNamespaceIfNotPresent(context, "in", "http://camel.apache.org/xml/in/");
        this.setNamespaceIfNotPresent(context, "out", "http://camel.apache.org/xml/out/");
        this.setNamespaceIfNotPresent(context, "env", "http://camel.apache.org/xml/variables/environment-variables");
        this.setNamespaceIfNotPresent(context, "system", "http://camel.apache.org/xml/variables/system-properties");
    }

    protected void setNamespaceIfNotPresent(DefaultNamespaceContext context, String prefix, String uri) {
        String current;
        if (context != null && (current = context.getNamespaceURI(prefix)) == null) {
            context.add(prefix, uri);
        }
    }

    protected XPathFunctionResolver createDefaultFunctionResolver(final XPathFunctionResolver parent) {
        return new XPathFunctionResolver(){

            public XPathFunction resolveFunction(QName qName, int argumentCount) {
                XPathFunction answer = null;
                if (parent != null) {
                    answer = parent.resolveFunction(qName, argumentCount);
                }
                if (answer == null) {
                    String localPart;
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/in/") || Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://activemq.apache.org/camel/schema/spring")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("body") && argumentCount == 0) {
                            return XPathBuilder.this.getBodyFunction();
                        }
                        if (localPart.equals("header") && argumentCount == 1) {
                            return XPathBuilder.this.getHeaderFunction();
                        }
                    }
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/out/")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("body") && argumentCount == 0) {
                            return XPathBuilder.this.getOutBodyFunction();
                        }
                        if (localPart.equals("header") && argumentCount == 1) {
                            return XPathBuilder.this.getOutHeaderFunction();
                        }
                    }
                }
                return answer;
            }
        };
    }

    protected Object getDocument(E exchange) {
        Message in = exchange.getIn();
        Class type = this.getDocumentType();
        Object answer = null;
        if (type != null) {
            answer = in.getBody(type);
        }
        if (answer == null) {
            answer = in.getBody();
        }
        if (answer instanceof String) {
            answer = new InputSource(new StringReader(answer.toString()));
        }
        MessageHelper.resetStreamCache(exchange.getIn());
        return answer;
    }
}

