/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetConsumer
extends DefaultConsumer<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(DataSetConsumer.class);
    private DataSetEndpoint endpoint;
    private Processor reporter;

    public DataSetConsumer(DataSetEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.reporter == null) {
            this.reporter = this.createReporter();
        }
        final DataSet dataSet = this.endpoint.getDataSet();
        final long preloadSize = this.endpoint.getPreloadSize();
        this.sendMessages(0L, preloadSize);
        this.endpoint.getExecutorService().execute(new Runnable(){

            public void run() {
                DataSetConsumer.this.sendMessages(preloadSize, dataSet.getSize());
            }
        });
    }

    protected void sendMessages(long startIndex, long endIndex) {
        try {
            for (long i = startIndex; i < endIndex; ++i) {
                Exchange exchange = this.endpoint.createExchange(i);
                this.getProcessor().process(exchange);
                try {
                    long delay = this.endpoint.getProduceDelay();
                    if (delay < 4L) {
                        delay = 4L;
                    }
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)e);
                }
                if (this.reporter == null) continue;
                this.reporter.process(exchange);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    protected ThroughputLogger createReporter() {
        ThroughputLogger answer = new ThroughputLogger(this.endpoint.getEndpointUri(), (int)this.endpoint.getDataSet().getReportCount());
        answer.setAction("Sent");
        return answer;
    }
}

