/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaComponent
extends DefaultComponent<Exchange> {
    private final Map<String, BlockingQueue<Exchange>> queues = new HashMap<String, BlockingQueue<Exchange>>();

    public synchronized BlockingQueue<Exchange> createQueue(String uri, Map parameters) {
        String key = this.getQueueKey(uri);
        if (this.queues.containsKey(key)) {
            return this.queues.get(key);
        }
        int size = this.getAndRemoveParameter(parameters, "size", Integer.class, 1000);
        LinkedBlockingQueue<Exchange> queue = new LinkedBlockingQueue<Exchange>(size);
        this.queues.put(key, queue);
        return queue;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        int consumers = this.getAndRemoveParameter(parameters, "concurrentConsumers", Integer.class, 1);
        return new SedaEndpoint(uri, this, this.createQueue(uri, parameters), consumers);
    }

    protected String getQueueKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf("?"));
        }
        return uri;
    }

    @Override
    protected void doStop() throws Exception {
        this.queues.clear();
        super.doStop();
    }
}

