/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.ThreadProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="thread")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadType
extends ProcessorType<ProcessorType> {
    @XmlAttribute(required=false)
    private Integer coreSize = 1;
    @XmlAttribute(required=false)
    private Boolean daemon = Boolean.TRUE;
    @XmlAttribute(required=false)
    private Long keepAliveTime;
    @XmlAttribute(required=false)
    private Integer maxSize = 1;
    @XmlAttribute(required=false)
    private String name = "Thread Processor";
    @XmlAttribute(required=false)
    private Integer priority = 5;
    @XmlAttribute(required=false)
    private Long stackSize;
    @XmlElementRef
    private List<ProcessorType<?>> outputs = new ArrayList();
    @XmlTransient
    private BlockingQueue<Runnable> taskQueue;
    @XmlTransient
    private ThreadGroup threadGroup;
    @XmlTransient
    private ThreadPoolExecutor executor;

    public ThreadType() {
    }

    public ThreadType(int coreSize) {
        this.coreSize = coreSize;
        this.maxSize = coreSize;
    }

    public ThreadType(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    public String toString() {
        return "Thread[" + this.name + "]";
    }

    @Override
    public String getShortName() {
        return "thread";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ThreadProcessor thread = new ThreadProcessor();
        thread.setExecutor(this.executor);
        if (this.coreSize != null) {
            thread.setCoreSize(this.coreSize);
        }
        if (this.daemon != null) {
            thread.setDaemon(this.daemon);
        }
        if (this.keepAliveTime != null) {
            thread.setKeepAliveTime(this.keepAliveTime);
        }
        if (this.maxSize != null) {
            thread.setMaxSize(this.maxSize);
        }
        thread.setName(this.name);
        thread.setPriority(this.priority);
        if (this.stackSize != null) {
            thread.setStackSize(this.stackSize);
        }
        thread.setTaskQueue(this.taskQueue);
        thread.setThreadGroup(this.threadGroup);
        ArrayList<Processor> pipe = new ArrayList<Processor>(2);
        pipe.add(thread);
        pipe.add(this.createOutputsProcessor(routeContext, this.outputs));
        return new Pipeline(pipe);
    }

    @Override
    protected void configureChild(ProcessorType output) {
        super.configureChild(output);
        if (this.isInheritErrorHandler()) {
            output.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
        }
    }

    @Override
    public ProcessorType errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        throw new IllegalArgumentException("Setting errorHandler on ThreadType is not supported. Instead set the errorHandler on the parent.");
    }

    public ThreadType coreSize(int coreSize) {
        this.setCoreSize(coreSize);
        return this;
    }

    public ThreadType daemon(boolean daemon) {
        this.setDaemon(daemon);
        return this;
    }

    public ThreadType keepAliveTime(long keepAliveTime) {
        this.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadType maxSize(int maxSize) {
        this.setMaxSize(maxSize);
        return this;
    }

    public ThreadType name(String name) {
        this.setName(name);
        return this;
    }

    public ThreadType priority(int priority) {
        this.setPriority(priority);
        return this;
    }

    public ThreadType stackSize(long stackSize) {
        this.setStackSize(stackSize);
        return this;
    }

    public ThreadType taskQueue(BlockingQueue<Runnable> taskQueue) {
        this.setTaskQueue(taskQueue);
        return this;
    }

    public ThreadType threadGroup(ThreadGroup threadGroup) {
        this.setThreadGroup(threadGroup);
        return this;
    }

    public ThreadType executor(ThreadPoolExecutor executor) {
        this.setExecutor(executor);
        return this;
    }

    public void setCoreSize(int coreSize) {
        this.coreSize = coreSize;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setStackSize(long stackSize) {
        this.stackSize = stackSize;
    }

    public void setTaskQueue(BlockingQueue<Runnable> taskQueue) {
        this.taskQueue = taskQueue;
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }
}

