/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.DelayPolicy;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spring.spi.TransactionInterceptor;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandlerBuilder
extends ErrorHandlerBuilderSupport
implements Cloneable,
InitializingBean {
    private TransactionTemplate transactionTemplate;
    private RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
    private DelayPolicy delayPolicy = new DelayPolicy();

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public DelayPolicy getDelayPolicy() {
        return this.delayPolicy;
    }

    public void setDelayPolicy(DelayPolicy delayPolicy) {
        this.delayPolicy = delayPolicy;
    }

    public ErrorHandlerBuilder copy() {
        try {
            return (ErrorHandlerBuilder)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone should be supported: " + e, e);
        }
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        return new TransactionInterceptor(processor, this.transactionTemplate, this.delayPolicy);
    }

    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.transactionTemplate, (String)"transactionTemplate");
    }

    public TransactionErrorHandlerBuilder backOffMultiplier(double backOffMultiplier) {
        this.getRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public TransactionErrorHandlerBuilder collisionAvoidancePercent(short collisionAvoidancePercent) {
        this.getRedeliveryPolicy().collisionAvoidancePercent((double)collisionAvoidancePercent);
        return this;
    }

    public TransactionErrorHandlerBuilder initialRedeliveryDelay(long initialRedeliveryDelay) {
        this.getDelayPolicy().delay(initialRedeliveryDelay);
        return this;
    }

    public TransactionErrorHandlerBuilder maximumRedeliveries(int maximumRedeliveries) {
        this.getRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public TransactionErrorHandlerBuilder maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public TransactionErrorHandlerBuilder useCollisionAvoidance() {
        this.getRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public TransactionErrorHandlerBuilder useExponentialBackOff() {
        this.getRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public TransactionErrorHandlerBuilder delay(long delay) {
        this.getDelayPolicy().delay(delay);
        return this;
    }
}

