/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointDeliveryChannel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class EndpointComponentContext
implements ComponentContext {
    private Endpoint endpoint;
    private ComponentContext context;
    private DeliveryChannel channel;

    public EndpointComponentContext(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.context = endpoint.getServiceUnit().getComponent().getComponentContext();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ComponentContext getComponentContext() {
        return this.context;
    }

    public ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        throw new UnsupportedOperationException();
    }

    public void deactivateEndpoint(ServiceEndpoint endpoint) throws JBIException {
        throw new UnsupportedOperationException();
    }

    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        throw new UnsupportedOperationException();
    }

    public String getComponentName() {
        return this.context.getComponentName();
    }

    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        if (this.channel == null) {
            this.channel = new EndpointDeliveryChannel(this.endpoint);
        }
        return this.channel;
    }

    public ServiceEndpoint getEndpoint(QName service, String name) {
        return this.context.getEndpoint(service, name);
    }

    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException {
        return this.context.getEndpointDescriptor(endpoint);
    }

    public ServiceEndpoint[] getEndpoints(QName interfaceName) {
        return this.context.getEndpoints(interfaceName);
    }

    public ServiceEndpoint[] getEndpointsForService(QName serviceName) {
        return this.context.getEndpointsForService(serviceName);
    }

    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) {
        return this.context.getExternalEndpoints(interfaceName);
    }

    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) {
        return this.context.getExternalEndpointsForService(serviceName);
    }

    public String getInstallRoot() {
        return this.context.getInstallRoot();
    }

    public Logger getLogger(String suffix, String resourceBundleName) throws MissingResourceException, JBIException {
        return this.context.getLogger(suffix, resourceBundleName);
    }

    public MBeanNames getMBeanNames() {
        return this.context.getMBeanNames();
    }

    public MBeanServer getMBeanServer() {
        return this.context.getMBeanServer();
    }

    public InitialContext getNamingContext() {
        return this.context.getNamingContext();
    }

    public Object getTransactionManager() {
        return this.context.getTransactionManager();
    }

    public String getWorkspaceRoot() {
        return this.context.getWorkspaceRoot();
    }

    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
        throw new UnsupportedOperationException();
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return this.context.resolveEndpointReference(epr);
    }
}

