/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.wsdl1;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.wsdl1.JbiEndpoint;
import org.apache.servicemix.common.wsdl1.JbiExtension;
import org.w3c.dom.Document;

public abstract class AbstractWsdl1Deployer
extends AbstractDeployer {
    protected FilenameFilter filter = new WsdlFilter();

    public AbstractWsdl1Deployer(ServiceMixComponent component) {
        super(component);
    }

    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File[] wsdls = new File(serviceUnitRootPath).listFiles(this.filter);
        return wsdls != null && wsdls.length > 0;
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        File[] wsdls = new File(serviceUnitRootPath).listFiles(this.filter);
        if (wsdls == null || wsdls.length == 0) {
            throw this.failure("deploy", "No wsdl found", null);
        }
        ServiceUnit su = this.createServiceUnit();
        su.setComponent(this.component);
        su.setName(serviceUnitName);
        su.setRootPath(serviceUnitRootPath);
        for (int i = 0; i < wsdls.length; ++i) {
            this.initFromWsdl(su, wsdls[i]);
        }
        if (su.getEndpoints().size() == 0) {
            throw this.failure("deploy", "Invalid wsdl: no endpoints found", null);
        }
        return su;
    }

    protected void initFromWsdl(ServiceUnit su, File wsdl) throws DeploymentException {
        Definition definition;
        Document description;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            description = factory.newDocumentBuilder().parse(wsdl);
            definition = this.createWsdlReader().readWSDL(null, description);
        }
        catch (Exception e) {
            throw this.failure("deploy", "Could not parse " + wsdl, e);
        }
        Map services = definition.getServices();
        if (services.size() == 0) {
            this.failure("deploy", "Invalid wsdl " + wsdl + ": no defined services", null);
        }
        for (Service svc : services.values()) {
            Iterator itPorts = svc.getPorts().values().iterator();
            while (itPorts.hasNext()) {
                JbiEndpoint jbiEndpoint = null;
                Port port = (Port)itPorts.next();
                ExtensibilityElement portElement = null;
                for (ExtensibilityElement elem : port.getExtensibilityElements()) {
                    if (elem instanceof JbiEndpoint) {
                        jbiEndpoint = (JbiEndpoint)elem;
                        continue;
                    }
                    if (!this.filterPortElement(elem)) continue;
                    if (portElement == null) {
                        portElement = elem;
                        continue;
                    }
                    throw this.failure("deploy", "Invalid wsdl " + wsdl + ": more than one port element match", null);
                }
                if (portElement == null) continue;
                Binding binding = port.getBinding();
                ExtensibilityElement bindingElement = null;
                for (ExtensibilityElement elem : binding.getExtensibilityElements()) {
                    if (!this.filterBindingElement(elem)) continue;
                    if (bindingElement == null) {
                        bindingElement = elem;
                        continue;
                    }
                    throw this.failure("deploy", "Invalid wsdl " + wsdl + ": more than one binding element match", null);
                }
                if (bindingElement == null) {
                    throw this.failure("deploy", "Invalid wsdl " + wsdl + ": no matching binding element found", null);
                }
                Endpoint ep = this.createEndpoint(portElement, bindingElement, jbiEndpoint);
                if (ep == null) continue;
                ep.setServiceUnit(su);
                ep.setDescription(description);
                ep.setDefinition(definition);
                ep.setService(svc.getQName());
                ep.setEndpoint(port.getName());
                ep.setInterfaceName(binding.getPortType().getQName());
                this.validate(ep);
                su.addEndpoint(ep);
            }
        }
    }

    protected WSDLReader createWsdlReader() throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        this.registerExtensions(registry);
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(registry);
        return reader;
    }

    protected void registerExtensions(ExtensionRegistry registry) {
        JbiExtension.register(registry);
    }

    protected ServiceUnit createServiceUnit() {
        return new ServiceUnit();
    }

    protected abstract Endpoint createEndpoint(ExtensibilityElement var1, ExtensibilityElement var2, JbiEndpoint var3);

    protected abstract boolean filterPortElement(ExtensibilityElement var1);

    protected abstract boolean filterBindingElement(ExtensibilityElement var1);

    public static class WsdlFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".wsdl");
        }
    }
}

