/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.console;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.jbi.management.DeploymentServiceMBean;
import javax.jbi.management.InstallationServiceMBean;
import javax.jbi.management.LifeCycleMBean;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.audit.AuditorMBean;
import org.apache.servicemix.jbi.management.ManagementContext;
import org.apache.servicemix.jbi.management.ManagementContextMBean;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ServiceMixPortlet
extends GenericPortlet {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected PortletRequestDispatcher normalView;
    protected PortletRequestDispatcher helpView;
    protected PortletRequestDispatcher errorView;
    private JMXConnector jmxConnector;
    private String namingHost = "localhost";
    private String containerName = "ServiceMix";
    private String jmxDomainName = "org.apache.servicemix";
    private int namingPort = 1099;
    private String jndiPath = "/jmxrmi";
    static /* synthetic */ Class class$org$apache$servicemix$jbi$framework$InstallationService;
    static /* synthetic */ Class class$javax$jbi$management$InstallationServiceMBean;
    static /* synthetic */ Class class$org$apache$servicemix$jbi$framework$DeploymentService;
    static /* synthetic */ Class class$javax$jbi$management$DeploymentServiceMBean;
    static /* synthetic */ Class class$org$apache$servicemix$jbi$management$ManagementContext;
    static /* synthetic */ Class class$org$apache$servicemix$jbi$management$ManagementContextMBean;
    static /* synthetic */ Class class$org$apache$servicemix$jbi$audit$jdbc$JdbcAuditor;
    static /* synthetic */ Class class$org$apache$servicemix$jbi$audit$AuditorMBean;
    static /* synthetic */ Class class$javax$jbi$management$LifeCycleMBean;

    public JMXServiceURL getServiceURL() {
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.namingHost + ":" + this.namingPort + this.jndiPath);
        }
        catch (MalformedURLException e) {
            this.log.error((Object)"error creating serviceURL: ", (Throwable)e);
        }
        return url;
    }

    public JMXConnector getJMXConnector(JMXServiceURL url) throws IOException {
        this.log.info((Object)("Connecting to JBI Container at: " + url));
        return JMXConnectorFactory.connect(url);
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.log.debug((Object)"doHelp");
        this.helpView.include(renderRequest, renderResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.log.debug((Object)"doView");
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        try {
            if (this.jmxConnector == null) {
                this.jmxConnector = this.getJMXConnector(this.getServiceURL());
            }
            this.renderView(renderRequest, renderResponse);
        }
        catch (PortletException e) {
            this.log.error((Object)"Error rendering portlet", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (IOException e) {
            this.log.error((Object)"Error rendering portlet", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (Exception e) {
            try {
                renderRequest.setAttribute("exception", (Object)e);
                this.errorView.include(renderRequest, renderResponse);
            }
            finally {
                this.closeConnector();
            }
        }
    }

    protected void renderView(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        this.fillViewRequest(renderRequest);
        this.normalView.include(renderRequest, renderResponse);
    }

    protected ObjectName getObjectName(Class systemClass) {
        return ManagementContext.getSystemObjectName((String)this.jmxDomainName, (String)this.containerName, (Class)systemClass);
    }

    protected void fillViewRequest(RenderRequest request) throws Exception {
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        this.log.debug((Object)"init");
        super.init(portletConfig);
        PortletContext pc = portletConfig.getPortletContext();
        this.normalView = pc.getRequestDispatcher("/WEB-INF/view/" + this.getPortletName() + "/view.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/" + this.getPortletName() + "/help.jsp");
        this.errorView = pc.getRequestDispatcher("/WEB-INF/view/error.jsp");
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        this.log.debug((Object)("processAction: " + actionRequest));
        try {
            if (this.jmxConnector == null) {
                this.jmxConnector = this.getJMXConnector(this.getServiceURL());
            }
            this.doProcessAction(actionRequest, actionResponse);
        }
        catch (PortletException e) {
            this.log.error((Object)"Error processing action", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (IOException e) {
            this.log.error((Object)"Error processing action", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing action", (Throwable)e);
            this.closeConnector();
            throw new PortletException("Error processing action", (Throwable)e);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
    }

    public void destroy() {
        this.closeConnector();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnector() {
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"caught an error closing the jmxConnector", (Throwable)e);
            }
            finally {
                this.jmxConnector = null;
            }
        }
    }

    public InstallationServiceMBean getInstallationService() throws IOException {
        ObjectName objectName = this.getObjectName(class$org$apache$servicemix$jbi$framework$InstallationService == null ? (class$org$apache$servicemix$jbi$framework$InstallationService = ServiceMixPortlet.class$((String)"org.apache.servicemix.jbi.framework.InstallationService")) : class$org$apache$servicemix$jbi$framework$InstallationService);
        return (InstallationServiceMBean)this.getProxy(objectName, class$javax$jbi$management$InstallationServiceMBean == null ? (class$javax$jbi$management$InstallationServiceMBean = ServiceMixPortlet.class$((String)"javax.jbi.management.InstallationServiceMBean")) : class$javax$jbi$management$InstallationServiceMBean);
    }

    public DeploymentServiceMBean getDeploymentService() throws IOException {
        ObjectName objectName = this.getObjectName(class$org$apache$servicemix$jbi$framework$DeploymentService == null ? (class$org$apache$servicemix$jbi$framework$DeploymentService = ServiceMixPortlet.class$((String)"org.apache.servicemix.jbi.framework.DeploymentService")) : class$org$apache$servicemix$jbi$framework$DeploymentService);
        return (DeploymentServiceMBean)this.getProxy(objectName, class$javax$jbi$management$DeploymentServiceMBean == null ? (class$javax$jbi$management$DeploymentServiceMBean = ServiceMixPortlet.class$((String)"javax.jbi.management.DeploymentServiceMBean")) : class$javax$jbi$management$DeploymentServiceMBean);
    }

    public ManagementContextMBean getManagementContext() throws IOException {
        ObjectName objectName = this.getObjectName(class$org$apache$servicemix$jbi$management$ManagementContext == null ? (class$org$apache$servicemix$jbi$management$ManagementContext = ServiceMixPortlet.class$((String)"org.apache.servicemix.jbi.management.ManagementContext")) : class$org$apache$servicemix$jbi$management$ManagementContext);
        return (ManagementContextMBean)this.getProxy(objectName, class$org$apache$servicemix$jbi$management$ManagementContextMBean == null ? (class$org$apache$servicemix$jbi$management$ManagementContextMBean = ServiceMixPortlet.class$((String)"org.apache.servicemix.jbi.management.ManagementContextMBean")) : class$org$apache$servicemix$jbi$management$ManagementContextMBean);
    }

    public AuditorMBean getJdbcAuditor() throws IOException {
        ObjectName objectName = this.getObjectName(class$org$apache$servicemix$jbi$audit$jdbc$JdbcAuditor == null ? (class$org$apache$servicemix$jbi$audit$jdbc$JdbcAuditor = ServiceMixPortlet.class$((String)"org.apache.servicemix.jbi.audit.jdbc.JdbcAuditor")) : class$org$apache$servicemix$jbi$audit$jdbc$JdbcAuditor);
        return (AuditorMBean)this.getProxy(objectName, class$org$apache$servicemix$jbi$audit$AuditorMBean == null ? (class$org$apache$servicemix$jbi$audit$AuditorMBean = ServiceMixPortlet.class$((String)"org.apache.servicemix.jbi.audit.AuditorMBean")) : class$org$apache$servicemix$jbi$audit$AuditorMBean);
    }

    public LifeCycleMBean getJBIContainer() throws IOException {
        ObjectName objectName = ManagementContext.getContainerObjectName((String)this.jmxDomainName, (String)this.containerName);
        return (LifeCycleMBean)this.getProxy(objectName, class$javax$jbi$management$LifeCycleMBean == null ? (class$javax$jbi$management$LifeCycleMBean = ServiceMixPortlet.class$((String)"javax.jbi.management.LifeCycleMBean")) : class$javax$jbi$management$LifeCycleMBean);
    }

    public Object getProxy(ObjectName name, Class type) throws IOException {
        return MBeanServerInvocationHandler.newProxyInstance(this.getServerConnection(), name, type, true);
    }

    public MBeanServerConnection getServerConnection() throws IOException {
        return this.jmxConnector.getMBeanServerConnection();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

