/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.console;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.jbi.management.DeploymentServiceMBean;
import javax.jbi.management.InstallationServiceMBean;
import javax.jbi.management.LifeCycleMBean;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.console.ContextLoaderListener;
import org.apache.servicemix.jbi.audit.AuditorMBean;
import org.apache.servicemix.jbi.audit.jdbc.JdbcAuditor;
import org.apache.servicemix.jbi.framework.DeploymentService;
import org.apache.servicemix.jbi.framework.InstallationService;
import org.apache.servicemix.jbi.management.ManagementContext;
import org.apache.servicemix.jbi.management.ManagementContextMBean;

public abstract class ServiceMixPortlet
extends GenericPortlet {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected PortletRequestDispatcher normalView;
    protected PortletRequestDispatcher helpView;
    protected PortletRequestDispatcher errorView;
    private JMXConnector jmxConnector;
    private String namingHost = "localhost";
    private String containerName = "ServiceMix";
    private String jmxDomainName = "org.apache.servicemix";
    private String jmxUrl;
    private int namingPort = 1099;
    private String jndiPath = "/jmxrmi";
    private String username;
    private String password;

    public JMXServiceURL getServiceURL() {
        JMXServiceURL url = null;
        if (url == null) {
            try {
                String jmxUrl = this.jmxUrl;
                if (jmxUrl == null) {
                    jmxUrl = "service:jmx:rmi:///jndi/rmi://" + this.namingHost + ":" + this.namingPort + this.jndiPath;
                }
                url = new JMXServiceURL(jmxUrl);
            }
            catch (MalformedURLException e) {
                this.log.error((Object)"error creating serviceURL: ", (Throwable)e);
            }
        }
        return url;
    }

    public JMXConnector getJMXConnector(JMXServiceURL url) throws IOException {
        this.log.info((Object)("Connecting to JBI Container at: " + url));
        String[] credentials = new String[]{this.username, this.password};
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        environment.put("jmx.remote.credentials", credentials);
        return JMXConnectorFactory.connect(url, environment);
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.log.debug((Object)"doHelp");
        this.helpView.include(renderRequest, renderResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        this.log.debug((Object)"doView");
        if (WindowState.MINIMIZED.equals((Object)renderRequest.getWindowState())) {
            return;
        }
        try {
            if (this.jmxConnector == null) {
                this.jmxConnector = this.getJMXConnector(this.getServiceURL());
            }
            this.renderView(renderRequest, renderResponse);
        }
        catch (PortletException e) {
            this.log.error((Object)"Error rendering portlet", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (IOException e) {
            this.log.error((Object)"Error rendering portlet", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (Exception e) {
            try {
                this.log.debug((Object)"Error rendering portlet", (Throwable)e);
                renderRequest.setAttribute("exception", (Object)e);
                this.errorView.include(renderRequest, renderResponse);
            }
            finally {
                this.closeConnector();
            }
        }
    }

    protected void renderView(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        this.fillViewRequest(renderRequest);
        this.normalView.include(renderRequest, renderResponse);
    }

    protected ObjectName getObjectName(Class systemClass) {
        return ManagementContext.getSystemObjectName((String)this.jmxDomainName, (String)this.getContainerName(), (Class)systemClass);
    }

    protected void fillViewRequest(RenderRequest request) throws Exception {
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        this.log.debug((Object)"init");
        super.init(portletConfig);
        PortletContext pc = portletConfig.getPortletContext();
        this.normalView = pc.getRequestDispatcher("/WEB-INF/view/" + this.getPortletName() + "/view.jsp");
        this.helpView = pc.getRequestDispatcher("/WEB-INF/view/" + this.getPortletName() + "/help.jsp");
        this.errorView = pc.getRequestDispatcher("/WEB-INF/view/error.jsp");
        this.jmxUrl = this.getConfigString("servicemixJmxUrl", this.jmxUrl);
        this.username = this.getConfigString("servicemixJmxUsername", this.username);
        this.password = this.getConfigString("servicemixJmxPassword", this.password);
        this.containerName = this.getConfigString("servicemixContainerName", this.containerName);
    }

    protected String getConfigString(String name, String defValue) {
        String v;
        ServletContext ctx = ContextLoaderListener.getServletContext();
        if (ctx != null && (v = ctx.getInitParameter(name)) != null) {
            return v;
        }
        return defValue;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        this.log.debug((Object)("processAction: " + actionRequest));
        try {
            if (this.jmxConnector == null) {
                this.jmxConnector = this.getJMXConnector(this.getServiceURL());
            }
            this.doProcessAction(actionRequest, actionResponse);
        }
        catch (PortletException e) {
            this.log.error((Object)"Error processing action", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (IOException e) {
            this.log.error((Object)"Error processing action", (Throwable)e);
            this.closeConnector();
            throw e;
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing action", (Throwable)e);
            this.closeConnector();
            throw new PortletException("Error processing action", (Throwable)e);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
    }

    public void destroy() {
        this.closeConnector();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnector() {
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"caught an error closing the jmxConnector", (Throwable)e);
            }
            finally {
                this.jmxConnector = null;
            }
        }
    }

    public InstallationServiceMBean getInstallationService() throws IOException {
        ObjectName objectName = this.getObjectName(InstallationService.class);
        return (InstallationServiceMBean)this.getProxy(objectName, InstallationServiceMBean.class);
    }

    public DeploymentServiceMBean getDeploymentService() throws IOException {
        ObjectName objectName = this.getObjectName(DeploymentService.class);
        return (DeploymentServiceMBean)this.getProxy(objectName, DeploymentServiceMBean.class);
    }

    public ManagementContextMBean getManagementContext() throws IOException {
        ObjectName objectName = this.getObjectName(ManagementContext.class);
        return (ManagementContextMBean)this.getProxy(objectName, ManagementContextMBean.class);
    }

    public AuditorMBean getJdbcAuditor() throws IOException {
        ObjectName objectName = this.getObjectName(JdbcAuditor.class);
        return (AuditorMBean)this.getProxy(objectName, AuditorMBean.class);
    }

    public LifeCycleMBean getJBIContainer() throws IOException {
        ObjectName objectName = ManagementContext.getContainerObjectName((String)this.jmxDomainName, (String)this.containerName);
        return (LifeCycleMBean)this.getProxy(objectName, LifeCycleMBean.class);
    }

    public Object getProxy(ObjectName name, Class type) throws IOException {
        return MBeanServerInvocationHandler.newProxyInstance(this.getServerConnection(), name, type, true);
    }

    public MBeanServerConnection getServerConnection() throws IOException {
        return this.jmxConnector.getMBeanServerConnection();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    protected String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected String getUsername() {
        return this.username;
    }

    protected void setUsername(String username) {
        this.username = username;
    }
}

