/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.console;

import java.net.URI;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.RenderRequest;
import org.apache.servicemix.console.JBIAuditPortlet;
import org.apache.servicemix.console.ServiceMixPortlet;
import org.apache.servicemix.jbi.audit.AuditorMBean;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.messaging.MessageExchangeSupport;

/*
 * Exception performing whole class analysis ignored.
 */
public class JBIAuditPortlet
extends ServiceMixPortlet {
    protected int page = 0;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        System.err.println(actionRequest.getParameterMap());
        if (actionRequest.getParameter("view") != null) {
            this.page = Integer.parseInt(actionRequest.getParameter("view"));
        }
    }

    protected void fillViewRequest(RenderRequest request) throws Exception {
        AuditorMBean auditor = this.getJdbcAuditor();
        int count = auditor.getExchangeCount();
        request.setAttribute("count", (Object)new Integer(count));
        request.setAttribute("page", (Object)new Integer(this.page));
        MessageExchange[] exchanges = auditor.getExchangesByRange(this.page * 10, Math.min((this.page + 1) * 10, count));
        request.setAttribute("exchanges", (Object)this.prepare(exchanges));
        super.fillViewRequest(request);
    }

    private ExchangeInfo[] prepare(MessageExchange[] exchanges) throws Exception {
        ExchangeInfo[] infos = new ExchangeInfo[exchanges.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new ExchangeInfo();
            ExchangeInfo.access$002((ExchangeInfo)infos[i], (String)exchanges[i].getExchangeId());
            ExchangeInfo.access$102((ExchangeInfo)infos[i], (String)this.getMep(exchanges[i]));
            ExchangeInfo.access$202((ExchangeInfo)infos[i], (String)exchanges[i].getStatus().toString());
            Object c = exchanges[i].getProperty("org.apache.servicemix.datestamp");
            if (c instanceof Calendar) {
                ExchangeInfo.access$302((ExchangeInfo)infos[i], (String)DateFormat.getDateTimeInstance().format(((Calendar)c).getTime()));
                continue;
            }
            if (!(c instanceof Date)) continue;
            ExchangeInfo.access$302((ExchangeInfo)infos[i], (String)DateFormat.getDateTimeInstance().format((Date)c));
        }
        return infos;
    }

    private String getMep(MessageExchange exchange) {
        URI uri = exchange.getPattern();
        if (MessageExchangeSupport.IN_ONLY.equals(uri)) {
            return "In Only";
        }
        if (MessageExchangeSupport.IN_OPTIONAL_OUT.equals(uri)) {
            return "In Opt Out";
        }
        if (MessageExchangeSupport.IN_OUT.equals(uri)) {
            return "In Out";
        }
        if (MessageExchangeSupport.ROBUST_IN_ONLY.equals(uri)) {
            return "Robust In Only";
        }
        return uri.toString();
    }

    private String prepareContent(NormalizedMessage msg) throws Exception {
        if (msg != null) {
            SourceTransformer st = new SourceTransformer();
            String s = st.contentToString(msg);
            if (s != null && s.length() > 30) {
                return s.substring(0, 30) + "...";
            }
            return s;
        }
        return null;
    }
}

